"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Popover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _coreChromeLayoutConstants = require("@kbn/core-chrome-layout-constants");
var _constants = require("../../constants");
var _use_layout_width = require("../../hooks/use_layout_width");
var _focus_adjacent_trigger = require("../../utils/focus_adjacent_trigger");
var _focus_first_element = require("../../utils/focus_first_element");
var _get_focusable_elements = require("../../utils/get_focusable_elements");
var _handle_roving_index = require("../../utils/handle_roving_index");
var _update_tab_indices = require("../../utils/update_tab_indices");
var _use_hover_timeout = require("../../hooks/use_hover_timeout");
var _use_scroll = require("../../hooks/use_scroll");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/side_nav/popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * The side nav popover differs from the regular `EuiPopover`:
 * - it opens on focus and hover, instead of just click,
 * - it handles keyboard navigation
 *   - Enter to move focus into the popover
 *   - Arrow keys to move focus between elements,
 *   - Escape to move focus back to the trigger.
 */
const Popover = ({
  children,
  container,
  hasContent,
  isSidePanelOpen,
  isAnyPopoverLocked = false,
  setIsLocked = () => {},
  label,
  persistent = false,
  trigger
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    setHoverTimeout,
    clearHoverTimeout
  } = (0, _use_hover_timeout.useHoverTimeout)();
  const popoverRef = (0, _react.useRef)(null);
  const triggerRef = (0, _react.useRef)(null);
  const [isOpenedByClick, setIsOpenedByClick] = (0, _react.useState)(false);
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const [shouldFocusOnOpen, setShouldFocusOnOpen] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (persistent) {
      setIsLocked(isOpenedByClick && isOpen);
    }
  }, [persistent, isOpenedByClick, isOpen, setIsLocked]);
  const setOpenedByClick = (0, _react.useCallback)(() => setIsOpenedByClick(true), []);
  const clearOpenedByClick = (0, _react.useCallback)(() => setIsOpenedByClick(false), []);
  const open = (0, _react.useCallback)(() => {
    setIsOpen(true);
  }, []);
  const close = (0, _react.useCallback)(() => {
    setIsOpen(false);
    clearOpenedByClick();
    clearHoverTimeout();
    setShouldFocusOnOpen(false);
  }, [clearOpenedByClick, clearHoverTimeout]);
  const handleClose = (0, _react.useCallback)(() => {
    clearHoverTimeout();
    close();
  }, [clearHoverTimeout, close]);
  const handleMouseEnter = (0, _react.useCallback)(() => {
    if ((!persistent || !isOpenedByClick) && (!isAnyPopoverLocked || isOpen)) {
      clearHoverTimeout();
      if (!isSidePanelOpen) {
        setHoverTimeout(open, _constants.POPOVER_HOVER_DELAY);
      }
    }
  }, [persistent, isOpenedByClick, isAnyPopoverLocked, isOpen, isSidePanelOpen, clearHoverTimeout, open, setHoverTimeout]);
  const handleMouseLeave = (0, _react.useCallback)(() => {
    if (!persistent || !isOpenedByClick) {
      setHoverTimeout(handleClose, _constants.POPOVER_HOVER_DELAY);
    }
  }, [persistent, isOpenedByClick, setHoverTimeout, handleClose]);
  const scrollStyles = (0, _use_scroll.useScroll)(true);
  const handleTriggerClick = (0, _react.useCallback)(() => {
    if (persistent) {
      if (isOpen && isOpenedByClick) {
        handleClose();
      } else {
        clearHoverTimeout();
        open();
        setOpenedByClick();
      }
    }
  }, [persistent, isOpen, isOpenedByClick, handleClose, clearHoverTimeout, open, setOpenedByClick]);
  const handleTriggerKeyDown = (0, _react.useCallback)(e => {
    if (e.key === 'Enter' || e.key === ' ') {
      var _trigger$props$onKeyD, _trigger$props;
      (_trigger$props$onKeyD = (_trigger$props = trigger.props).onKeyDown) === null || _trigger$props$onKeyD === void 0 ? void 0 : _trigger$props$onKeyD.call(_trigger$props, e);
      if (hasContent) {
        // Required for entering the popover with Enter or Space key
        // Otherwise the navigation happens immediately
        e.preventDefault();
        setShouldFocusOnOpen(true);
        open();
      }
    } else {
      var _trigger$props$onKeyD2, _trigger$props2;
      (_trigger$props$onKeyD2 = (_trigger$props2 = trigger.props).onKeyDown) === null || _trigger$props$onKeyD2 === void 0 ? void 0 : _trigger$props$onKeyD2.call(_trigger$props2, e);
    }
  }, [trigger, hasContent, open]);
  const handlePopoverKeyDown = (0, _react.useCallback)(e => {
    if (e.key === 'Escape') {
      var _triggerRef$current;
      handleClose();
      (_triggerRef$current = triggerRef.current) === null || _triggerRef$current === void 0 ? void 0 : _triggerRef$current.focus();
      return;
    }
    if (e.key === 'Tab') {
      e.preventDefault();
      handleClose();
      (0, _focus_adjacent_trigger.focusAdjacentTrigger)(triggerRef, e.shiftKey ? -1 : 1);
      return;
    }
    (0, _handle_roving_index.handleRovingIndex)(e);
  }, [handleClose]);
  const handleBlur = (0, _react.useCallback)(e => {
    var _triggerRef$current2, _popoverRef$current;
    clearHoverTimeout();
    const nextFocused = e.relatedTarget;
    const isStayingInComponent = nextFocused && Boolean(((_triggerRef$current2 = triggerRef.current) === null || _triggerRef$current2 === void 0 ? void 0 : _triggerRef$current2.contains(nextFocused)) || ((_popoverRef$current = popoverRef.current) === null || _popoverRef$current === void 0 ? void 0 : _popoverRef$current.contains(nextFocused)));
    if (isStayingInComponent === false) {
      handleClose();
    }
  }, [clearHoverTimeout, handleClose]);

  // Clean up on unmount
  (0, _react.useEffect)(() => {
    return () => {
      clearHoverTimeout();
      handleClose();
    };
  }, [clearHoverTimeout, handleClose]);
  const enhancedTrigger = (0, _react.useMemo)(() => /*#__PURE__*/(0, _react.cloneElement)(trigger, {
    ref: triggerRef,
    'aria-haspopup': hasContent,
    'aria-expanded': hasContent ? isOpen : undefined,
    onClick: e => {
      var _trigger$props$onClic, _trigger$props3;
      (_trigger$props$onClic = (_trigger$props3 = trigger.props).onClick) === null || _trigger$props$onClic === void 0 ? void 0 : _trigger$props$onClic.call(_trigger$props3, e);
      handleTriggerClick();
    },
    onKeyDown: handleTriggerKeyDown
  }), [trigger, hasContent, isOpen, handleTriggerKeyDown, handleTriggerClick]);
  const wrapperStyles = (0, _react2.css)`
    width: 100%;
  `;
  const popoverContentStyles = (0, _react2.css)`
    --popover-max-height: 37.5rem;
    width: ${_use_layout_width.SIDE_PANEL_WIDTH}px;
    max-height: var(--popover-max-height);
    ${scrollStyles};
  `;
  const maskStyles = (0, _react2.css)`
    position: fixed;
    inset: 0;
    z-index: calc(${euiTheme.levels.menu} - 1);
  `;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: wrapperStyles,
    onMouseEnter: handleMouseEnter,
    onMouseLeave: handleMouseLeave,
    onFocus: handleMouseEnter,
    onBlur: handleBlur,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "aria-label": label,
    anchorPosition: "rightUp",
    buffer: [_constants.TOP_BAR_HEIGHT + _constants.TOP_BAR_POPOVER_GAP, 0, _constants.BOTTOM_POPOVER_GAP, _constants.POPOVER_OFFSET],
    button: enhancedTrigger,
    closePopover: handleClose,
    container: container,
    display: "block",
    hasArrow: false,
    isOpen: hasContent && !isSidePanelOpen && isOpen,
    offset: _constants.POPOVER_OFFSET,
    ownFocus: false,
    panelPaddingSize: "none",
    repositionOnScroll: true,
    panelProps: {
      ..._coreChromeLayoutConstants.euiIncludeSelectorInFocusTrap.prop,
      'data-test-subj': `side-nav-popover-${label}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: ref => {
      popoverRef.current = ref;
      if (ref) {
        const elements = (0, _get_focusable_elements.getFocusableElements)(ref);
        (0, _update_tab_indices.updateTabIndices)(elements);
        if (shouldFocusOnOpen) {
          (0, _focus_first_element.focusFirstElement)(popoverRef);
          setShouldFocusOnOpen(false);
        }
      }
    },
    onKeyDown: handlePopoverKeyDown,
    css: popoverContentStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 9
    }
  }, typeof children === 'function' ? children(handleClose) : children)), persistent && isOpenedByClick && isOpen &&
  /*#__PURE__*/
  // The persistent popover does not affect keyboard navigation users
  // eslint-disable-next-line jsx-a11y/click-events-have-key-events
  _react.default.createElement("div", {
    onClick: handleClose,
    css: maskStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 9
    }
  }));
};
exports.Popover = Popover;