"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecondaryMenuSectionComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/secondary_menu/section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const SecondaryMenuSectionComponent = ({
  children,
  label
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const sectionId = label ? label.replace(/\s+/g, '-').toLowerCase() : undefined;
  const wrapperStyles = (0, _react2.css)`
    padding: ${euiTheme.size.m};

    &:not(:last-child) {
      border-bottom: 1px ${euiTheme.colors.borderBaseSubdued} solid;
    }
  `;

  /**
   * To reflect the design perfectly while maintaining a logical structure,
   * we need to use `6px` which isn't a multiple of 4 and there's no token for it,
   * hence why we're not using `euiTheme` here.
   */
  const labelStyles = (0, _react2.css)`
    font-size: ${euiTheme.size.m};
    color: ${euiTheme.colors.subduedText};
    padding: 6px ${euiTheme.size.s};
  `;
  const listStyles = (0, _react2.css)`
    display: flex;
    flex-direction: column;
    width: 100%;
    gap: ${euiTheme.size.xxs};
  `;
  return /*#__PURE__*/_react.default.createElement("nav", {
    css: wrapperStyles,
    "aria-labelledby": sectionId || undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, label && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    id: sectionId,
    css: labelStyles,
    component: "span",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, label), /*#__PURE__*/_react.default.createElement("ul", {
    css: listStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, children));
};
exports.SecondaryMenuSectionComponent = SecondaryMenuSectionComponent;