"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayoutApplication = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _coreChromeLayoutConstants = require("@kbn/core-chrome-layout-constants");
var _layout_application = require("./layout_application.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/layout/core-chrome-layout-components/application/layout_application.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * The application slot wrapper
 *
 * @param props - Props for the LayoutApplication component.
 * @returns The rendered LayoutApplication component.
 */
const LayoutApplication = ({
  children,
  topBar,
  bottomBar
}) => {
  // only restrict overflow scroll on screen (not print) to allow for full page printing
  const overflow = (0, _react2.css)`
    @media screen {
      ${(0, _eui.useEuiOverflowScroll)('y')};
    }
  `;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: [_layout_application.styles.root, overflow],
    id: _coreChromeLayoutConstants.APP_MAIN_SCROLL_CONTAINER_ID,
    className: "kbnChromeLayoutApplication",
    "data-test-subj": "kbnChromeLayoutApplication",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, topBar && /*#__PURE__*/_react.default.createElement("div", {
    css: _layout_application.styles.topBar,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 18
    }
  }, topBar), /*#__PURE__*/_react.default.createElement("div", {
    css: [_layout_application.styles.content],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, children), bottomBar && /*#__PURE__*/_react.default.createElement("div", {
    css: _layout_application.styles.bottomBar,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 21
    }
  }, bottomBar));
};
exports.LayoutApplication = LayoutApplication;