"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCummulativeLogger = createCummulativeLogger;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function createCummulativeLogger(logger) {
  const migrationLogs = [];
  return {
    debug(message, meta) {
      logger.debug(message, meta);
    },
    trace(message, meta) {
      logger.trace(message, meta);
    },
    fatal(message, meta) {
      logger.fatal(message, meta);
    },
    log(record) {
      logger.log(record);
    },
    isLevelEnabled(level) {
      return logger.isLevelEnabled(level);
    },
    clear() {
      migrationLogs.length = 0;
    },
    dump() {
      migrationLogs.forEach(log => {
        const level = log.level === 'warning' ? 'warn' : log.level;
        logger[level](log.message);
      });
    },
    error(errorOrMessage) {
      migrationLogs.push({
        level: 'error',
        message: errorOrMessage.toString()
      });
    },
    get(...childContextPaths) {
      return createCummulativeLogger(logger.get(...childContextPaths));
    },
    info(message) {
      migrationLogs.push({
        level: 'info',
        message: message.toString()
      });
    },
    warn(errorOrMessage) {
      migrationLogs.push({
        level: 'warning',
        message: errorOrMessage.toString()
      });
    }
  };
}