"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducer = exports.initialValue = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const initialResultValue = {
  data: null,
  type: 'unknown'
};
const initialValue = exports.initialValue = {
  requestInFlight: false,
  lastResult: initialResultValue
};
const reducer = (state, action) => {
  const draft = (0, _lodash.cloneDeep)(state);
  if (action.type === 'sendRequest') {
    draft.requestInFlight = true;
    draft.lastResult = initialResultValue;
    return draft;
  }
  if (action.type === 'requestSuccess') {
    draft.requestInFlight = false;
    draft.lastResult = action.payload;
    return draft;
  }
  if (action.type === 'requestFail') {
    draft.requestInFlight = false;
    draft.lastResult = {
      ...initialResultValue,
      error: action.payload
    };
    return draft;
  }
  if (action.type === 'cleanRequest') {
    draft.requestInFlight = false;
    draft.lastResult = initialResultValue;
    return draft;
  }
  return state;
};
exports.reducer = reducer;