"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BasicAuth = void 0;
var _v = require("@kbn/zod/v4");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const authSchema = _v.z.object({
  username: _v.z.string().meta({
    sensitive: true
  }).describe('Username'),
  password: _v.z.string().meta({
    sensitive: true
  }).describe('Password')
});
/**
 * HTTP Basic Authentication
 * Use for: Username + Password auth (Jira, etc.)
 */
const BasicAuth = exports.BasicAuth = {
  id: 'basic',
  schema: authSchema,
  configure: (axiosInstance, secret) => {
    // set global defaults
    axiosInstance.defaults.auth = {
      username: secret.username,
      password: secret.password
    };
    return axiosInstance;
  }
};