"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpecialAssignment = SpecialAssignment;
var _reactRedux = require("react-redux");
var _react = _interopRequireDefault(require("react"));
var _color_swatch = require("../color_picker/color_swatch");
var _color_mapping = require("../../state/color_mapping");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-coloring/src/shared_components/color_mapping/components/assignment/special_assignment.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function SpecialAssignment({
  assignmentColor,
  index,
  palette,
  palettes,
  isDarkMode,
  total
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  return /*#__PURE__*/_react.default.createElement(_color_swatch.ColorSwatch, {
    forType: "specialAssignment",
    colorMode: {
      type: 'categorical'
    },
    assignmentColor: assignmentColor,
    palettes: palettes,
    index: index,
    palette: palette,
    total: total,
    swatchShape: "square",
    isDarkMode: isDarkMode,
    onColorChange: color => {
      dispatch((0, _color_mapping.updateSpecialAssignmentColor)({
        assignmentIndex: index,
        color
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  });
}