"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Policies = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18n = require("@kbn/i18n");
var _cloud_defend_page_title = require("../../components/cloud_defend_page_title");
var _cloud_defend_page = require("../../components/cloud_defend_page");
var _policies_table = require("../../components/policies_table");
var _use_cloud_defend_policies = require("./use_cloud_defend_policies");
var _helpers = require("../../../common/utils/helpers");
var TEST_SUBJ = _interopRequireWildcard(require("./test_subjects"));
var _constants = require("../../common/constants");
var _use_page_size = require("../../common/hooks/use_page_size");
var _use_cloud_defend_integration_links = require("../../common/navigation/use_cloud_defend_integration_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_defend/public/pages/policies/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SEARCH_DEBOUNCE_MS = 300;
const AddIntegrationButton = () => {
  const {
    addIntegrationLink
  } = (0, _use_cloud_defend_integration_links.useCloudDefendIntegrationLinks)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": TEST_SUBJ.ADD_INTEGRATION_TEST_SUBJ,
    fill: true,
    iconType: "plusInCircle",
    href: addIntegrationLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cloudDefend.policies.policiesPageHeader.addIntegrationButtonLabel",
    defaultMessage: "Add Integration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }));
};
const EmptyState = ({
  name
}) => /*#__PURE__*/_react.default.createElement("div", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 55,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 56,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 58,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement("strong", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 59,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.cloudDefend.policies.policyEmptyState.integrationsNotFoundTitle",
  defaultMessage: "No policies found",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 60,
    columnNumber: 11
  }
}), name && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.cloudDefend.policies.policyEmptyState.integrationsNotFoundForNameTitle",
  defaultMessage: " for \"{name}\"",
  values: {
    name
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 65,
    columnNumber: 13
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 74,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 75,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
  color: "subdued",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.cloudDefend.policies.policyEmptyState.integrationsNotFoundWithFiltersTitle",
  defaultMessage: "We weren't able to find any policies with the above filters.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 77,
    columnNumber: 9
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 83,
    columnNumber: 5
  }
}));
const TotalIntegrationsCount = ({
  pageCount,
  totalCount
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  css: {
    marginLeft: 8
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 91,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
  color: "subdued",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 92,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.cloudDefend.policies.totalIntegrationsCountMessage",
  defaultMessage: "Showing {pageCount} of {totalCount, plural, one {# integration} other {# integrations}}",
  values: {
    pageCount,
    totalCount
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 93,
    columnNumber: 7
  }
})));
const SearchField = ({
  onSearch,
  isLoading
}) => {
  const [localValue, setLocalValue] = (0, _react.useState)('');
  (0, _useDebounce.default)(() => onSearch(localValue), SEARCH_DEBOUNCE_MS, [localValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: {
      alignItems: 'flex-end'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    fullWidth: true,
    onSearch: setLocalValue,
    isLoading: isLoading,
    placeholder: _i18n.i18n.translate('xpack.cloudDefend.policies.policySearchField.searchPlaceholder', {
      defaultMessage: 'Search integration name'
    }),
    incremental: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  })));
};
const Policies = () => {
  var _queryResult$data, _queryResult$data2, _queryResult$data3;
  const {
    pageSize,
    setPageSize
  } = (0, _use_page_size.usePageSize)(_constants.LOCAL_STORAGE_PAGE_SIZE);
  const [query, setQuery] = (0, _react.useState)({
    name: '',
    page: 1,
    perPage: pageSize,
    sortField: 'package_policy.name',
    sortOrder: 'asc'
  });
  const queryResult = (0, _use_cloud_defend_policies.useCloudDefendPolicies)(query);
  const totalItemCount = ((_queryResult$data = queryResult.data) === null || _queryResult$data === void 0 ? void 0 : _queryResult$data.total) || 0;
  return /*#__PURE__*/_react.default.createElement(_cloud_defend_page.CloudDefendPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": TEST_SUBJ.POLICIES_PAGE_HEADER,
    pageTitle: /*#__PURE__*/_react.default.createElement(_cloud_defend_page_title.CloudDefendPageTitle, {
      title: _i18n.i18n.translate('xpack.cloudDefend.policies.policiesPageHeader', {
        defaultMessage: 'Defend for containers (D4C)'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 11
      }
    }),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(AddIntegrationButton, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 26
      }
    })],
    bottomBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(SearchField, {
    isLoading: queryResult.isFetching,
    onSearch: name => setQuery(current => ({
      ...current,
      name
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(TotalIntegrationsCount, {
    pageCount: (((_queryResult$data2 = queryResult.data) === null || _queryResult$data2 === void 0 ? void 0 : _queryResult$data2.items) || []).length,
    totalCount: totalItemCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_policies_table.PoliciesTable, {
    policies: ((_queryResult$data3 = queryResult.data) === null || _queryResult$data3 === void 0 ? void 0 : _queryResult$data3.items) || [],
    "data-test-subj": TEST_SUBJ.POLICIES_TABLE_DATA_TEST_SUBJ,
    error: queryResult.error ? (0, _helpers.extractErrorMessage)(queryResult.error) : undefined,
    loading: queryResult.isFetching,
    pageIndex: query.page,
    pageSize: pageSize || query.perPage,
    sorting: {
      // @ts-expect-error - EUI types currently do not support sorting by nested fields
      sort: {
        field: query.sortField,
        direction: query.sortOrder
      },
      allowNeutralSort: false
    },
    totalItemCount: totalItemCount,
    setQuery: ({
      page,
      sort
    }) => {
      setPageSize(page.size);
      setQuery(current => ({
        ...current,
        page: page.index,
        perPage: page.size,
        sortField: (sort === null || sort === void 0 ? void 0 : sort.field) || current.sortField,
        sortOrder: (sort === null || sort === void 0 ? void 0 : sort.direction) || current.sortOrder
      }));
    },
    noItemsMessage: queryResult.isSuccess && !queryResult.data.total ? /*#__PURE__*/_react.default.createElement(EmptyState, {
      name: query.name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 13
      }
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }));
};
exports.Policies = Policies;