"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudDataMigrationPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _common = require("../common");
var _breadcrumbs = require("./application/services/breadcrumbs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class CloudDataMigrationPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "breadcrumbService", new _breadcrumbs.BreadcrumbService());
  }
  setup(core, {
    cloud,
    management
  }) {
    // Only be applies to self-managed instances of Kibana. Any Kibana instance running on
    // Elastic Cloud should not show any information related to migration.
    if (!cloud.isCloudEnabled) {
      management.sections.section.data.registerApp({
        id: _common.PLUGIN_ID,
        title: _common.PLUGIN_NAME,
        order: 8,
        mount: async params => {
          const [coreStart] = await core.getStartServices();
          const {
            setBreadcrumbs
          } = params;

          // Initialize services
          this.breadcrumbService.setup(setBreadcrumbs);
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
          // Render the application
          const unmountAppCallback = renderApp(coreStart, this.breadcrumbService, params);
          return () => {
            unmountAppCallback();
          };
        }
      });
    }
  }
  start(core, {
    cloud
  }) {
    if (!(cloud !== null && cloud !== void 0 && cloud.isCloudEnabled)) {
      core.chrome.registerGlobalHelpExtensionMenuLink({
        linkType: 'custom',
        target: '_blank',
        href: 'https://ela.st/cloud-migration',
        content: _i18n.i18n.translate('xpack.cloudDataMigration.helpMenuMoveDataTitle', {
          defaultMessage: 'Move data to Elastic Cloud'
        }),
        'data-test-subj': 'migrate_data_to_cloud__help_menu_link',
        priority: 200,
        external: true
      });
    }
  }
  stop() {}
}
exports.CloudDataMigrationPlugin = CloudDataMigrationPlugin;