"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DropIllustration = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-chart-icons/src/assets/drop_illustration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const DropIllustration = ({
  title,
  titleId,
  ...props
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("svg", (0, _extends2.default)({
    xmlns: "http://www.w3.org/2000/svg",
    width: "176",
    height: "176",
    viewBox: "0 0 176 176",
    "aria-labelledby": titleId
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  }), title ? /*#__PURE__*/_react.default.createElement("title", {
    id: titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 16
    }
  }, title) : null, /*#__PURE__*/_react.default.createElement("path", {
    fill: "#16C5C0",
    d: "M122.155 89.485H12.389v40.796h109.766V89.485Z",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#00B0AA",
    d: "M19.471 91.253c.358-.28.786-.454 1.236-.503A1.664 1.664 0 0 1 22 92.647a1.842 1.842 0 0 1-1.801 1.375 1.65 1.65 0 0 1-1.513-1.69c.156-.426.428-.799.785-1.079Zm-6.188 3.1c.137 0 .618-.07.646-.275.027-.207-.358-.482-.509-.496a.482.482 0 0 0-.495.317c-.041.22.206.412.357.454h.001Zm-.908 5.197v1.952c.097.108.22.188.357.234a1.156 1.156 0 0 0 1.376-1.086c.096-.536-.372-1.018-1.142-1.141-.197-.03-.4-.016-.591.041Zm34.375 9.213a.796.796 0 0 0-.921.371c-.385.619-.33.921.275 1.54a11.082 11.082 0 0 0 0 1.65.547.547 0 0 0 .714.524.559.559 0 0 0 .276-.194c.076-.103.16-.203.245-.304.314-.373.64-.759.607-1.332l-.591-.605c.041-.798-.192-1.527-.605-1.65Zm-33.096 5.211a.726.726 0 0 0-.646-.88 2.299 2.299 0 0 0-.62 0v2.131h.152a.715.715 0 0 0-.165.275v.468a.442.442 0 0 0 .316.343c.385.097.578-.44.591-.618.014-.179 0-.564-.357-.605h-.055c.395-.257.676-.656.784-1.114Zm.261 1.952c-.165-.041-.165-.206-.165-.33a.348.348 0 0 1 .22-.124c.082.042.289.193.192.262a.26.26 0 0 0-.074.097c-.035.063-.067.122-.173.095Zm-1.54 2.613v.632a1.704 1.704 0 0 0 1.169.853 1.062 1.062 0 0 0 1.265-.839 1.377 1.377 0 0 0-1.059-1.568 1.536 1.536 0 0 0-1.375.922Zm1.293 4.304a1.383 1.383 0 0 0 1.457-.894 1.51 1.51 0 0 0-1.182-1.595c-.427 0-.95.522-1.045 1.169a1.111 1.111 0 0 0 .77 1.32Zm11.809-1.457c.158.123.29.277.387.453.962.247 1.553.948 1.347 1.705a1.963 1.963 0 0 1-1.925 1.471 1.898 1.898 0 0 1-1.375-1.746 1.225 1.225 0 0 1-.234-.894c.11-.66.784-1.334 1.265-1.251.195.05.377.139.535.262Zm4.91.989a1.375 1.375 0 0 0-1.265.701 1.16 1.16 0 0 0-.357.151c.038.136.066.274.082.413a2.8 2.8 0 0 0-.082.33 1.154 1.154 0 0 0 1.072 1.375 1.375 1.375 0 0 0 1.664-1.375 1.47 1.47 0 0 0-1.113-1.595h-.001Zm-4.262 7.164a1.008 1.008 0 0 0 .523.632c.343.124.838-.371.756-.756-.06-.28-.186-.378-.281-.453a.5.5 0 0 1-.09-.083c-.633-.028-1.032.371-.908.66Zm4.386-1.059c.232.136.433.319.591.536a2.69 2.69 0 0 1 .523-.014 1.008 1.008 0 0 1 .839.935.804.804 0 0 1-.096.33h-4.126a1.38 1.38 0 0 1 .124-.605c.454-1.045 1.375-1.54 2.145-1.182Zm-5.514.536a.9.9 0 0 0 .908-.838c0-.468-.289-.674-.729-.715a.826.826 0 0 0-.864.43.83.83 0 0 0-.098.326.75.75 0 0 0 .476.745.765.765 0 0 0 .307.052Zm11.688.344c.041-.853.44-1.251 1.127-1.251.757.055 1.458.646 1.43 1.21 0 .288-.453.701-.92.948h-1.156a1.199 1.199 0 0 1-.481-.907Zm14.286-7.205c.124-.22.097-.385-.137-.495-.234-.11-.372-.082-.495.138a.315.315 0 0 0 .124.481.3.3 0 0 0 .135.072c.05.013.102.014.153.001a.307.307 0 0 0 .22-.197ZM13.2 130.267h-.825v-6.985c.072-.015.154-.046.245-.08h.001v-.001c.394-.148.945-.355 1.514.37.333.425-.1.878-.317 1.105a1.169 1.169 0 0 0-.095.105.781.781 0 0 1 .646-.151.743.743 0 0 1 .674.866v.151a1.87 1.87 0 0 1 2.447 0 1.702 1.702 0 0 1-.11-.907.851.851 0 0 1 .839-.784c.742-.055 1.595.701 1.375 1.155-.18.42-.488.771-.88 1.004h.192a.866.866 0 0 1 .77.839c.01.363-.106.718-.33 1.003.66-.151 1.471.702 1.279 1.637-.047.232-.14.452-.275.646h-3.3c-.137-.206-.275-1.664.151-1.898.326-.178.716.077.943.226.07.045.125.081.157.091.113.033.18-.043.283-.163.023-.026.047-.055.075-.085h-.138a2.188 2.188 0 0 1-.976-.852 1.77 1.77 0 0 1-1.128.701 2.63 2.63 0 0 1-.632.261 1.623 1.623 0 0 1-.371-.399 1.842 1.842 0 0 1-.825-1.636c.02-.123.057-.244.11-.357a.77.77 0 0 1-.234.123c.12.29-.057.572-.2.8a1.422 1.422 0 0 0-.13.232c-.045.116.03.18.153.285.14.12.34.291.493.65.289.673-.632 1.595-1.609 1.375h-.096c.098.21.14.442.124.673Zm4.895-4.056h-.082a.582.582 0 0 1-.317-.192c.052.109.089.225.11.343.092-.058.189-.109.289-.151Zm22.358-1.87c-.633-.068-1.018.317-1.114 1.073a.18.18 0 0 0-.083.069 1.373 1.373 0 0 0 .316 1.375 1.23 1.23 0 0 0 1.306-.385.783.783 0 0 0 .62-.605 1.842 1.842 0 0 0-1.045-1.527Zm-19.345 1.893a.813.813 0 0 1-.208-.573.907.907 0 0 1 .963-.77.825.825 0 0 1 .715.977.733.733 0 0 1-.318.525.749.749 0 0 1-.604.107.813.813 0 0 1-.548-.266Zm28.575-6.065a1.194 1.194 0 0 1-.073-.709 1.373 1.373 0 0 1 1.32-.426.962.962 0 0 1 .237 1.483.873.873 0 0 1-1.021.194 1.19 1.19 0 0 1-.463-.542Zm-32.358-1.919a.55.55 0 0 0-.605.66c0 .275.151 1.004.536.976.385-.027.756-.646.798-.921.041-.275-.275-.715-.729-.715Zm5.795 8.839c.213.248.34.557.365.882-.041.481-.564.812-1.306.812h-.33a1.09 1.09 0 0 1-.756-1.018c.04-.55.742-1.169 1.21-1.169.318.073.604.246.817.493Zm-.937 1.694h-.004.041-.037Zm0 0c-.675.012-1.338.366-1.338.866-.007.206.04.409.138.591h2.392a.734.734 0 0 0 0-.165c0-.837-.315-1.222-1.192-1.292Zm-2.15-12.114c0 .605.317 1.003.674.907a1.046 1.046 0 0 0 .633-.522c.124-.344-.371-.839-.756-.757a.712.712 0 0 0-.452.273.51.51 0 0 1-.099.099Zm5.34 9.231a.53.53 0 0 1 .023.256c-.027.454-.44.756-.715.715-.275-.041-.88-.412-.907-.797-.028-.385.701-.523.976-.523a.536.536 0 0 1 .623.349Zm2.127 4.312h.481a.621.621 0 0 0-.481 0Zm-4.648-6.366c.138.083.33.33.234.536-.082.193-.398.22-.55.179-.151-.041-.454-.412-.371-.605.082-.192.55-.192.688-.11h-.001Zm25.617 6.422.192-.33c.154-.016.306-.049.454-.097a.858.858 0 0 0-.083.413h2.984a1.202 1.202 0 0 0-.445-1.285 1.209 1.209 0 0 0-.435-.2 1.944 1.944 0 0 0-1.059 0 .8.8 0 0 0-.563-.536c-.688-.22-.963-.083-1.375.646a14.59 14.59 0 0 0-1.609.385.583.583 0 0 0-.34.318.587.587 0 0 0-.004.466 2.011 2.011 0 0 0-1.1.275l3.383-.055Zm7.38-16.424a.77.77 0 0 1-.01-.393c.811-.426 1.1-.426 1.292-.041a.782.782 0 0 1-.343.963.767.767 0 0 1-.939-.529Zm-3.795 1.45c.125.043.24.113.334.206.508.316.536.646.412.853-.124.206.316.261.481.123.165-.137.592-.316.99.262.399.577-.233 1.058-.66 1.292-.426.234-.728.33-1.072 0-.16-.154-.321-.182-.505-.215-.21-.037-.452-.079-.76-.321a1.376 1.376 0 0 1-.261-1.843.891.891 0 0 1 .651-.401.876.876 0 0 1 .39.044Zm-17.074 1.155c0-.165-.22-.427-.357-.44-.138-.014-.537 0-.55.412-.013.378.31.398.49.41l.046.003c.165.013.385-.262.371-.385Zm4.318 2.447c-.798-.275-1.032-.756-.798-1.375.248-.284.59-.47.962-.522a.76.76 0 0 1-.618-.605 1.032 1.032 0 0 1 .88-.99.347.347 0 0 1 .358.385c.002.092.012.196.022.302.031.34.065.71-.091.825a.765.765 0 0 1 .316 0c.343.165.522.633.343 1.169-.288.811-.577 1.086-1.374.811Zm15.014-7.755c0-.044.009-.093.018-.144.026-.155.055-.326-.141-.419a.301.301 0 0 0-.26-.022.31.31 0 0 0-.18.187c-.069.165-.179.577 0 .687.178.11.55-.192.563-.289Zm-5.898 14.011a.43.43 0 0 1 .178.138c.24-.141.526-.185.798-.124.536.138.962 1.238.536 1.513a.933.933 0 0 1-.715 0 .77.77 0 0 1 0 .275c-.178.509-.756.66-1.457.371a.949.949 0 0 1-.206-.11c.027.082-.042.536-.386.468-.343-.069-.343-.427-.343-.592a.314.314 0 0 1 .22-.302.909.909 0 0 1 0-.88 1.116 1.116 0 0 1 1.375-.757Zm-3.685 4.098c.082-.344-.426-.962-.853-1.059a.678.678 0 0 0-.524.136.67.67 0 0 0-.246.483c-.096.701 0 1.196.399 1.279a1.38 1.38 0 0 0 1.224-.839Zm13.166-11.052a.757.757 0 0 1-.31-.031.844.844 0 0 1-.549-.794c0-.114.023-.228.068-.333a.686.686 0 0 1 .88-.523.895.895 0 0 1 .577 1.1.766.766 0 0 1-.666.581Zm-22.806 4.809a1.372 1.372 0 0 1-.81.014 1.168 1.168 0 0 1-.413-1.499.663.663 0 0 1 .633-.467 1.5 1.5 0 0 1 .88-.165c.426.082.632.303.632.77-.03.264-.119.518-.261.742v.138a1.38 1.38 0 0 1-.661.467Zm-5.169-11.852c.22 0 .412-.206.454-.357.041-.152-.083-.619-.289-.647-.206-.027-.481.358-.481.509 0 .151.096.468.316.495Zm.591 2.805c-.096.412-1.058.66-1.375.412-.261-.247-.261-1.402.578-1.416a.934.934 0 0 1 .289 0c.068-.165.26-.412.426-.412a.447.447 0 0 1 .289.398 1.103 1.103 0 0 1-.207.427 1.22 1.22 0 0 1 0 .591Zm22.44 7.04c-.027-1.224.426-2.516 2.214-2.228.342.056.672-.045.99-.142.386-.118.753-.231 1.1-.05a2.116 2.116 0 0 1 .949 1.774 2.6 2.6 0 0 1-1.746 2.598 1.113 1.113 0 0 1-.867 0c-.19.191-.402.357-.632.495a.988.988 0 0 1-.564-.756 1.69 1.69 0 0 1-1.031-.577 1.897 1.897 0 0 1-.413-1.114Zm-31.061-3.383c0 .495.619.674.907.743.29.069.564-.289.592-.646.027-.358-.275-.825-.633-.729-.048.013-.1.025-.155.038-.344.081-.758.178-.711.594Zm-1.733-10.546c.07-.371 1.403-1.059 1.61-.783.233.275.467 1.154-.235 1.347-.7.192-1.443-.192-1.375-.564Zm6.958 19.127a1.249 1.249 0 0 0 .77 1.746 1.182 1.182 0 0 0 1.526-.536 1.776 1.776 0 0 0-.949-1.994c-.28-.04-.566.015-.81.157a1.26 1.26 0 0 0-.537.627Zm.99-3.658c.027 0 .124.22.124.22-.041.069-.193.289-.261.192-.024-.032-.055-.055-.085-.078-.059-.043-.112-.083-.094-.183.027-.151.288-.151.316-.151ZM33 127.077a1.38 1.38 0 0 0-1.375.674c-.124.317.289 1.004.701 1.155a.602.602 0 0 0 .702-.22 1.52 1.52 0 0 0 .948.757.827.827 0 0 0 .922-.784c.08.046.162.088.247.124a1.149 1.149 0 0 0 1.329-.271 1.14 1.14 0 0 0 .238-.417 1.37 1.37 0 0 0-.852-1.953 1.488 1.488 0 0 0-1.856.661 1.194 1.194 0 0 0 .11 1.045 1.446 1.446 0 0 0-.866.33c.068-.605-.014-1.004-.248-1.101Zm-9.996-16.747c.069.124.22.467.069.591a.535.535 0 0 1-.592.055c-.179-.069-.344-.467-.179-.646a.635.635 0 0 1 .702 0Zm-8.195 2.984h-.275a.804.804 0 0 0-.44.866 1.18 1.18 0 0 0 .22.715c.239-.06.483-.102.729-.124a.69.69 0 0 0-.262.523 1.733 1.733 0 0 0 1.375 1.622 1.276 1.276 0 0 0 1.045-1.182 1.09 1.09 0 0 0-1.114-1.279 1.733 1.733 0 0 0-.538-.002c.02-.005.06-.026.071-.108.044-.228-.208-.45-.454-.666-.14-.124-.277-.245-.357-.365Zm1.99-6.431c.043.175.044.357.003.532a.899.899 0 0 1-1.03.585.901.901 0 0 1-.386-.186 1.045 1.045 0 0 1-.222-.83 1.042 1.042 0 0 1 .484-.71.989.989 0 0 1 .907.137c.117.136.2.298.244.472Zm.884 16.619c.49.176.881.032 1.14-.063.145-.053.248-.091.303-.047.022.018.052.048.089.085.22.218.688.681 1.135.328a1.075 1.075 0 0 0 .426-1.375 1.06 1.06 0 0 0 .949-.743 1.76 1.76 0 0 0 0-.66c.162-.105.31-.229.44-.371a1.374 1.374 0 0 0-.165-2.117 1.54 1.54 0 0 0-2.255.371c-.394.54-.25.955-.133 1.295.104.3.187.541-.142.754-.316.205-.51.146-.712.085-.247-.075-.508-.154-1.02.231-.936.701-.84 1.939-.055 2.227Zm.893-9.377c.206-.096.537.124.537.289.055.178-.014.536-.22.563a.637.637 0 0 1-.578-.343.443.443 0 0 1 .261-.509Zm2.186 1.581a.605.605 0 0 0 .66.715 1.063 1.063 0 0 0 .757-.412c.11-.206-.179-.99-.564-1.031a.795.795 0 0 0-.852.728h-.001Zm11.804 8.348a.34.34 0 0 1 .145.026c.087.019.184.035.283.052.343.058.715.121.79.292a.771.771 0 0 1-.798 1.003 1.043 1.043 0 0 1-.728-1.1.329.329 0 0 1 .308-.273Zm37.311-5.226c-.77-.11-1.636.412-1.677 1.003-.041.592.564 1.114 1.182 1.169a1.21 1.21 0 0 0 1.21-1.114c.07-.618-.178-.99-.715-1.058Zm-1.503 4.809c.014-.231.082-.456.197-.657a1.374 1.374 0 0 1 .704-.862 1.364 1.364 0 0 1 1.111-.059 2.063 2.063 0 0 1 1.238 2.103 1.69 1.69 0 0 1-2.131 1.032 1.51 1.51 0 0 1-.605-.324 1.511 1.511 0 0 1-.514-1.233Zm4.075-14.325a1.378 1.378 0 0 0-1.636.413c-.248.481.15 1.182.866 1.526a1.003 1.003 0 0 0 1.182-.44 1.208 1.208 0 0 0-.412-1.499Zm-12.26 19.874a1.609 1.609 0 0 1-.789-.899 1.556 1.556 0 0 1 1.251-1.581c.88-.014 1.843.371 1.843 1.004a1.568 1.568 0 0 1-1.114 1.581 1.614 1.614 0 0 1-1.191-.105Zm6.54-4.707a1.87 1.87 0 0 0-2.132.866 1.568 1.568 0 0 0 .702 2.062 2.48 2.48 0 0 0 2.406-.907 1.608 1.608 0 0 0-.976-2.021Zm-3.819-8.983a1.583 1.583 0 0 1 1.11-.092 1.538 1.538 0 0 1 .605 1.884 1.582 1.582 0 0 1-1.815.385 1.089 1.089 0 0 1-.674-1.375 1.58 1.58 0 0 1 .774-.802Zm6.362-1.77c-.577-.275-1.058 0-1.375.743a1.375 1.375 0 0 0 .358 1.526 1.514 1.514 0 0 0 1.76-.646 1.374 1.374 0 0 0-.743-1.623Zm-10.725 16.033c.22-.344.674-.344 1.197 0 .149.114.31.211.481.288.17.052.332.126.481.22h-2.269a.633.633 0 0 1 .11-.508Zm13.503-2.558a1.185 1.185 0 0 0 1.61 1.176c.247-.096.455-.273.59-.502a1.458 1.458 0 0 0-.578-1.774c-.398-.151-1.443.537-1.622 1.1Zm-58.74-17.545a.878.878 0 0 1 .261 0 1.624 1.624 0 0 1 1.1 1.581 1.227 1.227 0 0 1-1.375.784 1.651 1.651 0 0 1-.921-.357v-1.375a2.75 2.75 0 0 0 .097-.123c.044-.059.088-.117.137-.166h-.234v-5.115a1.114 1.114 0 0 1 1.114 1.54 1.279 1.279 0 0 0 0 .715 2.75 2.75 0 0 1 .178 1.87 1.468 1.468 0 0 1-.357.646Zm-.935-4.771v-.66a.55.55 0 0 1 0 .66Zm1.705-.22a.892.892 0 0 0 .674 1.031.908.908 0 0 0 1.017-.701 1.032 1.032 0 0 0-.756-1.114.881.881 0 0 0-.935.784Zm60.76 13.21c.166.323.21.695.125 1.049a1.507 1.507 0 0 1-1.377 1.105 1.51 1.51 0 0 1-.617-.101 1.176 1.176 0 0 1-.876-1.048c-.012-.163.01-.326.065-.479a1.665 1.665 0 0 1 1.898-1.237c.337.135.616.387.782.711Zm-10.394 3.551c-.09.552.336.793.785 1.046l.095.054.165-.114c.398-.272.797-.544.591-1.123a.35.35 0 0 0-.082-.151 2.02 2.02 0 0 0 1.155-1.073.852.852 0 0 0-.605-1.045 1.222 1.222 0 0 0-.955-.053 1.218 1.218 0 0 0-.695.658 1.375 1.375 0 0 0 .11 1.183.836.836 0 0 0-.564.618Zm22.15.271a.555.555 0 0 1 .029.307c0 .206-.426.137-.605.082a.548.548 0 0 1-.316-.522c.055-.206.564-.193.701-.11a.546.546 0 0 1 .191.243Zm1.968 5.669a1.198 1.198 0 0 0-1.375.77c-.22.592-.083 1.004.426 1.21a1.47 1.47 0 0 0 1.76-.563 1.378 1.378 0 0 0-.811-1.417Zm-4.895-8.772c.398.069.412.509.288.825-.082.316-.398.564-1.003.316a2.767 2.767 0 0 0-.06-.228c-.062-.221-.137-.486-.078-.624.083-.193.454-.358.853-.289Zm6.325 3.781a.467.467 0 0 0-.234-.591.498.498 0 0 0-.426-.027.515.515 0 0 0-.322.524.505.505 0 0 0 .418.452.527.527 0 0 0 .564-.358Zm2.224-2.268a.685.685 0 0 1 .292-.015c.069.014.247.275.151.427l-.038.064c-.103.175-.273.466-.54.321-.237-.13-.177-.396-.14-.557a.57.57 0 0 0 .017-.103.67.67 0 0 1 .258-.137Zm-31.086-.482a.762.762 0 0 0 .423-.446.768.768 0 0 0-.038-.613c-.123-.247-.48-.563-.728-.55-.619 0-.839.523-.908 1.128l.007.006c.328.301.711.653 1.244.475Zm15.712 6.117c-.285-.221-.688-.535-.518-.933.168-.432.608-.341 1.019-.256l.177.036c.454.082.55.481.372.88-.179.398-.647.618-.894.398a3.646 3.646 0 0 0-.156-.125Zm-18.049-18.217c-.22.674.564 1.073.949.921a.808.808 0 0 0 .343-.962.739.739 0 0 0-.658-.357.74.74 0 0 0-.634.398Zm3.892 1.969c.25-.043.506 0 .728.121a1.38 1.38 0 0 1 .66 1.306c-.069.619-.316.88-.963.88h-1.044v.564a1.563 1.563 0 0 1-1.554 1.609.975.975 0 0 1-.715-.248 2.018 2.018 0 0 1-.591-1.87 1.76 1.76 0 0 1 1.553-1.127h.564a4.96 4.96 0 0 1 .715-.88c.17-.188.398-.313.647-.355Zm19.14 10.131c-.798-.481-1.21-.385-1.65.44a48.023 48.023 0 0 1-.794 1.426l-.238.417c-1.182-.55-1.375-.482-1.554.604.44.509.908.454 1.375 0 1.279.963 2.104.523 2.324-1.168.103-.047.209-.089.316-.124.468-.069.605-.399.647-.811a.854.854 0 0 0-.427-.784h.001Zm-2.198 9.221c.004-.179.045-.355.121-.517.399-.963 1.196-1.444 1.911-1.155a1.762 1.762 0 0 1 .963 1.883 1.735 1.735 0 0 1-2.145 1.032 1.303 1.303 0 0 1-.85-1.243Zm-1.68-15.312a1.09 1.09 0 0 0-.811.233c-.427.523-.152.99.357 1.472.084-.03.17-.055.253-.081.427-.128.824-.248.847-.799a.756.756 0 0 0-.646-.825ZM28.6 116.641c-.179-.014-.715-.206-.619-.591.11-.371.619-.371.798-.33a.547.547 0 0 1 .426.564c-.041.357-.426.371-.605.357Zm11.866-3.891a.818.818 0 0 0-.632.454.551.551 0 0 0 .495.729c.233 0 .866-.083.907-.606.042-.522-.563-.577-.77-.577Zm-3.011 9.57c-.082-.234-.014-.715.151-.811.383-.15.704-.427.908-.784.041-.096.247-.179.357-.179.413.124.468.564.413.715-.06.162-.124.322-.192.481a1.229 1.229 0 0 1 .66 1.004c-.015.33-.716.756-1.128.756a.919.919 0 0 1-.688-.715 1.053 1.053 0 0 1-.481-.467Zm3.699-3.52a.646.646 0 0 0 .481.852.195.195 0 0 0 .096 0c.207.239.48.411.784.495a1.207 1.207 0 0 0 1.306-.618 2.024 2.024 0 0 0-.701-1.884 1.377 1.377 0 0 0-1.279.619.617.617 0 0 0-.687.536ZM15.252 96.463a.963.963 0 0 1 .67-.213.949.949 0 0 1 .84 1.017.894.894 0 0 1-.936.784 1.06 1.06 0 0 1-.921-.976.963.963 0 0 1 .347-.612Zm21.53 21.333a1.227 1.227 0 0 0-1.307.66.865.865 0 0 0 .591 1.059.977.977 0 0 0 1.169-.426c.151-.399-.11-1.197-.454-1.293h.001Zm-1.238 6.683c.206-.083.687-.138.825 0 .272.314.638.531 1.045.619.083.01.15.122.207.217.02.032.037.061.054.085-.027.413-.192.578-.578.578a7.28 7.28 0 0 1-1.375-.234c-.206-.069-.522-.316-.522-.495.01-.292.133-.569.344-.77Zm9.061-10.354a1.016 1.016 0 0 0-1.114.577c-.261.839-.096 1.513.426 1.678a1.173 1.173 0 0 0 .944-.039 1.188 1.188 0 0 0 .614-.718 1.186 1.186 0 0 0-.431-1.298 1.187 1.187 0 0 0-.439-.2Zm1.99 2.892c.142-.042.285-.085.416-.142a1.38 1.38 0 0 1 1.252.303 1.124 1.124 0 0 1 .44 1.072 1.378 1.378 0 0 1-.936 1.059 1.84 1.84 0 0 1-1.54-.344c-.219-.179-.272-.366-.321-.539-.019-.065-.037-.129-.063-.19a.839.839 0 0 1 0-.756c.106-.27.421-.364.752-.463Zm-4.809-1.256a.443.443 0 0 0 .413.371.626.626 0 0 0 .495-.467c0-.206-.303-.358-.509-.358-.206 0-.44.193-.399.454Zm2.136 5.613a1.525 1.525 0 0 1 .174-1.075 1.996 1.996 0 0 1 1.1-.717 1.994 1.994 0 0 1 1.307.125 1.668 1.668 0 0 1 .247 2.324 1.371 1.371 0 0 1-2.241.261 1.524 1.524 0 0 1-.587-.918Zm-7.828-6.534a.65.65 0 0 0-.547.016.652.652 0 0 0-.347.424.605.605 0 0 0 .33.839.643.643 0 0 0 .949-.248.75.75 0 0 0-.132-.858.764.764 0 0 0-.253-.173Zm6.448-3.121c.097-.248.344-.248.523-.248.096 0 .509.206.358.481-.126.229-.385.211-.564.198a1.025 1.025 0 0 0-.096-.005.323.323 0 0 1-.208-.163.316.316 0 0 1-.013-.263Zm-1.003-2.585c-.248.509 0 1.265.426 1.375.426.11 1.375-1.004 1.169-1.485-.206-.481-1.348-.399-1.595.11Zm-23.224-4.125a.627.627 0 0 0 .577.343c.207 0 .276-.385.22-.563-.054-.179-.33-.385-.536-.289a.439.439 0 0 0-.261.509Zm-2.14-4.767a.813.813 0 0 1 .614-.046c.572.149.582.574.593 1.037.003.094.005.189.012.283-.839.385-1.238.426-1.513 0a1.048 1.048 0 0 1-.11-.811.817.817 0 0 1 .405-.463h-.001Zm1.205 11.326c0 .398.124.715.495.797a4.882 4.882 0 0 0 2.874-.082 1.54 1.54 0 0 0 .371-.275 1.088 1.088 0 0 0-.633-1.884h-.11c.092-.127.153-.273.18-.426a.8.8 0 0 0-.784-.908.754.754 0 0 0-.894.66c-.004.202.034.404.11.591h-.317a1.706 1.706 0 0 0-1.292 1.527Zm4.473-11.346a1.47 1.47 0 0 1 1-.342c.742.028 1.512 1.155 1.36 2.062a1.25 1.25 0 0 1-1.498 1.032 1.574 1.574 0 0 1-1.35-1.194 1.59 1.59 0 0 1-.025-.635c.05-.361.234-.69.513-.923Zm2.608 8.829c.138.358 1.375.537 1.54 0a.836.836 0 0 0-.357-1.058c-.481-.138-1.32.701-1.183 1.058Zm2.187 8.451c.176-.041.359-.044.536-.008.563.041 1.155.632 1.1 1.168a1.756 1.756 0 0 1-1.691 1.375c-.51 0-.908-.687-.908-1.375a1.252 1.252 0 0 1 .963-1.16Zm22.398-2.937a.881.881 0 0 0-1.072.413.735.735 0 0 0 .105.867c.07.076.156.137.252.178a.88.88 0 0 0 1.073-.413.725.725 0 0 0-.358-1.045ZM25.878 97.611c-.083-.151-.083-.756.165-.839a.77.77 0 0 1 .7.358.688.688 0 0 1-.22.632.673.673 0 0 1-.645-.151Zm-2.063 16.156c-.413 0-.921.482-1.045 1.265.033.034.07.081.112.133.113.143.257.326.438.376a.67.67 0 0 0 .289 0c.165.096.398 0 .577-.206a.836.836 0 0 0 .385-.495 1.062 1.062 0 0 0-.756-1.073Zm6.29 6.069a1.27 1.27 0 0 1 .585-.569c.32-.143.65-.258.99-.343a1.635 1.635 0 0 1 .468 2.268c-.184.267-.466.45-.784.509a1.372 1.372 0 0 1-1.375-1.059 1.261 1.261 0 0 1 .116-.806Z",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#16C5C0",
    d: "M135.905 24.86H26.139v40.796h109.766V24.86Z",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#00B0AA",
    d: "M33.218 26.624c.358-.28.788-.453 1.24-.499a1.664 1.664 0 0 1 1.292 1.898 1.842 1.842 0 0 1-1.801 1.375 1.65 1.65 0 0 1-1.513-1.692c.154-.427.425-.802.782-1.082Zm-6.186 3.104c.138 0 .62-.07.647-.276.027-.206-.358-.48-.509-.495a.482.482 0 0 0-.495.317c-.041.22.206.412.357.453v.001Zm-.907 5.197v1.953c.097.107.22.188.358.233a1.153 1.153 0 0 0 1.375-1.086c.11-.536-.372-1.017-1.142-1.141-.198-.03-.4-.016-.591.041ZM60.5 44.138a.798.798 0 0 0-.921.37c-.385.62-.33.922.275 1.54-.04.55-.04 1.102 0 1.65a.55.55 0 0 0 .99.33c.076-.102.16-.202.245-.303.314-.373.64-.759.607-1.333l-.591-.605c.041-.797-.192-1.525-.605-1.649Zm-33.096 4.905c.022.1.022.205 0 .306a1.87 1.87 0 0 1-.798 1.114h.069c.357.04.371.426.357.605-.013.178-.206.715-.59.618a.44.44 0 0 1-.317-.357v-.454a.715.715 0 0 1 .165-.275h-.151v-2.131c.205-.028.413-.028.619 0a.727.727 0 0 1 .646.574Zm.096 1.928c0 .124 0 .289.165.33.106.027.138-.032.173-.095.02-.036.04-.073.075-.097.096-.069-.11-.22-.193-.262a.344.344 0 0 0-.22.124Zm-1.375 3.575v-.632a1.54 1.54 0 0 1 1.375-.922 1.374 1.374 0 0 1 1.059 1.568 1.061 1.061 0 0 1-1.265.839 1.72 1.72 0 0 1-1.169-.853Zm2.177 3.479c-.265.162-.576.23-.884.193a1.113 1.113 0 0 1-.77-1.32c.096-.647.618-1.17 1.044-1.17a1.513 1.513 0 0 1 1.183 1.596 1.375 1.375 0 0 1-.573.7v.001Zm11.312-.811a1.372 1.372 0 0 0-.921-.715c-.482-.083-1.155.591-1.265 1.251-.042.317.042.638.233.894a1.898 1.898 0 0 0 1.375 1.746 1.967 1.967 0 0 0 1.925-1.471c.206-.756-.385-1.458-1.347-1.705Zm3.791.707c.224-.124.477-.183.733-.171a1.47 1.47 0 0 1 1.113 1.595 1.374 1.374 0 0 1-1.663 1.375 1.155 1.155 0 0 1-1.073-1.375 2.84 2.84 0 0 1 .082-.33 2.739 2.739 0 0 0-.082-.413c.11-.07.23-.121.358-.15.124-.224.309-.407.532-.531Zm-3.336 7.365a1.002 1.002 0 0 1-.194-.372c-.124-.289.275-.688.907-.66.023.03.055.055.09.083.096.075.222.173.282.453.082.385-.413.88-.757.756a1.004 1.004 0 0 1-.328-.26Zm4.783-.895c-.158-.217-.36-.4-.59-.536-.77-.357-1.692.138-2.146 1.182-.086.19-.129.397-.123.605h4.124a.812.812 0 0 0 .097-.33 1.004 1.004 0 0 0-.839-.934 2.613 2.613 0 0 0-.523.013Zm-5.486-.24a.908.908 0 0 1-.618.24.759.759 0 0 1-.784-.797.838.838 0 0 1 .962-.757c.44.042.729.248.729.715a.91.91 0 0 1-.289.599Zm12.197-.667c-.688 0-1.087.398-1.128 1.251a1.21 1.21 0 0 0 .481.907h1.155c.468-.247.922-.66.922-.948.027-.564-.674-1.155-1.43-1.21Zm13.02-6.449c.234.11.262.275.138.495a.317.317 0 0 1-.508.124.316.316 0 0 1-.124-.482c.124-.22.26-.247.494-.137Zm-38.458 8.608h.811a1.376 1.376 0 0 0-.123-.674h.096c.976.22 1.897-.701 1.608-1.375a1.636 1.636 0 0 0-.493-.65c-.122-.105-.198-.17-.153-.285.027-.068.076-.146.13-.232.143-.228.32-.51.2-.8a.77.77 0 0 0 .234-.123c-.053.113-.09.234-.11.357a1.84 1.84 0 0 0 .825 1.637c.1.152.226.287.371.398.221-.06.434-.147.633-.261.452-.079.856-.33 1.127-.701.232.376.572.673.977.852h.137l-.075.085c-.103.12-.17.196-.282.163-.033-.01-.087-.046-.157-.091-.228-.149-.618-.404-.944-.225-.426.233-.288 1.69-.15 1.897h3.3a1.73 1.73 0 0 0 .274-.646c.193-.935-.618-1.788-1.278-1.636.223-.286.34-.641.33-1.004a.852.852 0 0 0-.77-.839.916.916 0 0 0-.193 0c.393-.232.7-.584.88-1.004.22-.453-.633-1.21-1.375-1.155a.853.853 0 0 0-.839.784c-.046.307-.008.62.11.907a1.65 1.65 0 0 0-1.045-.467 1.677 1.677 0 0 0-1.375.426v-.151a.77.77 0 0 0-.674-.88.84.84 0 0 0-.646.165 1.57 1.57 0 0 1 .085-.09c.219-.22.68-.685.328-1.12-.57-.725-1.12-.518-1.514-.37-.09.035-.174.066-.246.081l-.014 7.027Zm5.624-4.126h.096c-.03.013-.06.026-.088.04l-.008-.04Zm-.303-.192a.577.577 0 0 0 .28.247c-.058.03-.115.062-.17.097a1.006 1.006 0 0 0-.11-.344Zm21.643-.536c.096-.757.481-1.073 1.114-1.073a1.841 1.841 0 0 1 1.044 1.526.783.783 0 0 1-.618.605 1.223 1.223 0 0 1-1.306.386 1.375 1.375 0 0 1-.317-1.444.18.18 0 0 1 .083 0Zm-18.439.247a.812.812 0 0 0 .756.839.743.743 0 0 0 .922-.633.852.852 0 0 0-.716-.99.935.935 0 0 0-.962.784Zm28.71-6.201a1.197 1.197 0 0 0 .536 1.251.88.88 0 0 0 1.21-.508.962.962 0 0 0-.426-1.17 1.374 1.374 0 0 0-1.32.427Zm-32.542-1.18a.55.55 0 0 1 .257-.03c.454 0 .77.44.729.715-.041.275-.413.894-.798.921-.385.028-.536-.701-.536-.976a.55.55 0 0 1 .348-.63Zm6.417 9.691a1.526 1.526 0 0 0-1.182-1.375c-.468-.068-1.17.619-1.21 1.169a1.086 1.086 0 0 0 .756 1.017h.334c-.675.013-1.338.367-1.338.853-.008.21.04.419.138.605h2.392a.723.723 0 0 0 0-.165c0-.837-.315-1.223-1.192-1.293l.037.001h-.041c.742 0 1.265-.33 1.306-.812Zm-2.777-10.395c-.358.096-.674-.302-.674-.907a.492.492 0 0 0 .098-.099.705.705 0 0 1 .452-.273c.385-.082.88.413.756.757a1.045 1.045 0 0 1-.632.522Zm4.688 8.58a.534.534 0 0 0-.646-.605c-.275 0-1.004.138-.976.523.027.385.632.756.907.797.275.041.688-.261.715-.715Zm2.585 4.057h-.481a.605.605 0 0 1 .481 0Zm-4.895-5.83a.468.468 0 0 0-.233-.537 1.13 1.13 0 0 1-.099-.006c-.187-.015-.521-.041-.589.116-.082.193.22.564.371.605.151.041.468.014.55-.178ZM69.6 49.218a.77.77 0 0 1-.01-.393c.811-.426 1.1-.44 1.292-.041a.783.783 0 0 1-.344.963.77.77 0 0 1-.938-.529Zm-3.795 1.45c.125.043.24.114.334.206.508.316.536.646.412.852-.124.207.316.262.481.124.165-.137.591-.316.99.261.399.578-.234 1.06-.66 1.293-.426.234-.729.33-1.072 0-.16-.153-.318-.182-.5-.215a1.492 1.492 0 0 1-.765-.335 1.375 1.375 0 0 1-.261-1.829.893.893 0 0 1 1.041-.357ZM48.73 51.824c0-.165-.22-.426-.357-.44-.138-.014-.537 0-.55.412-.013.378.31.398.49.41.017 0 .032.002.046.003.165.013.385-.262.371-.385Zm4.318 2.447c-.798-.275-1.032-.756-.798-1.375.23-.27.545-.454.894-.522a.756.756 0 0 1-.619-.605 1.03 1.03 0 0 1 .88-.99.332.332 0 0 1 .358.371l.004.02c.082.398.198.96-.005 1.121a.77.77 0 0 1 .317 0c.343.165.632.358.343 1.169-.288.811-.577 1.086-1.374.811Zm15.014-7.755c0-.044.009-.093.018-.144.026-.155.055-.326-.141-.42a.302.302 0 0 0-.44.166c-.069.164-.179.577 0 .687.178.11.55-.193.564-.289h-.001Zm3.583 7.057a.77.77 0 0 1-.31-.03.853.853 0 0 1-.481-1.128.69.69 0 0 1 .88-.523.894.894 0 0 1 .577 1.1.772.772 0 0 1-.666.581Zm-22.806 4.81a1.38 1.38 0 0 1-.81.013 1.169 1.169 0 0 1-.413-1.498.66.66 0 0 1 .633-.468 1.5 1.5 0 0 1 .88-.165c.426.082.632.303.632.77a1.76 1.76 0 0 1-.261.743v.137c-.169.219-.4.383-.661.468ZM43.67 46.53c.22 0 .413-.206.454-.358.041-.15-.083-.618-.289-.646-.206-.027-.481.358-.481.509a.48.48 0 0 0 .316.495Zm.591 2.805c-.096.413-1.059.66-1.375.413-.261-.248-.261-1.403.578-1.417a.94.94 0 0 1 .288 0c.07-.165.262-.412.427-.412a.453.453 0 0 1 .288.399 1.1 1.1 0 0 1-.206.426c.049.194.049.397 0 .591Zm22.44 7.04c-.027-1.224.427-2.516 2.214-2.227.342.055.672-.046.99-.143.386-.118.753-.231 1.1-.05a2.118 2.118 0 0 1 .949 1.774 2.6 2.6 0 0 1-1.746 2.599 1.115 1.115 0 0 1-.867 0c-.19.19-.402.356-.632.494a.99.99 0 0 1-.564-.756 1.69 1.69 0 0 1-1.031-.577 1.897 1.897 0 0 1-.413-1.114ZM35.64 52.992c0 .495.619.674.907.743.29.069.564-.289.592-.646.027-.358-.275-.825-.633-.73-.048.014-.1.026-.155.039-.344.081-.758.178-.711.594Zm-1.733-10.546c.07-.371 1.403-1.058 1.61-.783.233.275.467 1.155-.235 1.347-.7.193-1.444-.192-1.375-.564Zm6.958 19.127a1.253 1.253 0 0 0 .77 1.746 1.183 1.183 0 0 0 1.526-.537 1.773 1.773 0 0 0-.935-1.993 1.266 1.266 0 0 0-1.361.783v.001Zm.99-3.658c.028 0 .124.22.124.22-.041.069-.193.289-.261.193-.024-.033-.055-.056-.085-.079-.059-.043-.112-.083-.094-.183.027-.151.288-.151.316-.151Zm4.895 4.538a1.375 1.375 0 0 0-1.375.673c-.124.317.289 1.004.701 1.155a.605.605 0 0 0 .702-.22 1.499 1.499 0 0 0 .948.756.825.825 0 0 0 .922-.783l.247.123a1.142 1.142 0 0 0 1.567-.687 1.375 1.375 0 0 0-.852-1.953 1.485 1.485 0 0 0-1.856.66 1.196 1.196 0 0 0 .11 1.045c-.317.013-.62.129-.866.33.068-.605-.014-1.002-.248-1.099Zm-9.996-16.748c.069.124.22.468.069.591a.535.535 0 0 1-.592.055c-.178-.069-.343-.467-.178-.646a.633.633 0 0 1 .7 0h.001Zm-8.195 2.984h-.275a.81.81 0 0 0-.44.866 1.18 1.18 0 0 0 .22.715c.239-.06.483-.102.729-.124a.689.689 0 0 0-.262.523 1.732 1.732 0 0 0 1.375 1.622 1.279 1.279 0 0 0 1.045-1.182 1.087 1.087 0 0 0-1.114-1.279 1.733 1.733 0 0 0-.538-.002c.02-.005.06-.026.071-.108.044-.228-.208-.45-.454-.666-.14-.124-.277-.245-.357-.365Zm1.99-6.43c.043.174.044.356.003.531a.893.893 0 0 1-1.416.399 1.032 1.032 0 0 1 .262-1.54.991.991 0 0 1 .907.137c.117.136.2.299.244.473Zm.884 16.618c.49.176.882.032 1.14-.063.145-.053.248-.091.303-.047.022.018.052.048.089.084.22.219.688.682 1.135.329a1.073 1.073 0 0 0 .426-1.375 1.06 1.06 0 0 0 .949-.742 1.76 1.76 0 0 0 0-.66c.161-.105.31-.23.44-.372a1.375 1.375 0 0 0-.165-2.117 1.54 1.54 0 0 0-2.255.371c-.394.54-.25.957-.132 1.294.104.298.186.535-.143.741-.314.197-.507.143-.709.086-.247-.07-.508-.143-1.024.244-.934.701-.838 1.939-.054 2.227Zm.893-9.377c.206-.096.536.124.536.289.055.178-.013.536-.22.563a.62.62 0 0 1-.577-.357.44.44 0 0 1 .261-.495Zm2.187 1.581a.603.603 0 0 0 .66.715 1.056 1.056 0 0 0 .756-.412c.11-.206-.179-.99-.564-1.032a.798.798 0 0 0-.852.729Zm11.803 8.348a.33.33 0 0 1 .145.026c.087.019.184.035.283.052.343.058.715.121.79.292a.772.772 0 0 1-.798 1.004 1.045 1.045 0 0 1-.728-1.1.33.33 0 0 1 .308-.274Zm37.311-5.227c-.77-.11-1.636.413-1.677 1.004-.041.591.564 1.114 1.182 1.169a1.21 1.21 0 0 0 1.21-1.114c.07-.619-.178-.99-.715-1.059Zm1.683-9.589c.296-.075.609-.048.889.075a1.21 1.21 0 0 1 .412 1.498 1.004 1.004 0 0 1-1.182.44c-.715-.343-1.114-1.045-.867-1.526.189-.24.452-.412.748-.487Zm-7.54 6.166a1.581 1.581 0 0 0-1.884.893 1.086 1.086 0 0 0 .674 1.376 1.58 1.58 0 0 0 1.815-.386 1.54 1.54 0 0 0-.605-1.883Zm3.877-.935c.317-.743.798-1.018 1.375-.743a1.375 1.375 0 0 1 .743 1.623 1.514 1.514 0 0 1-1.76.646 1.374 1.374 0 0 1-.358-1.526ZM27.321 45.03h-.261c.174-.175.297-.393.358-.632a2.75 2.75 0 0 0-.18-1.884 1.225 1.225 0 0 1 0-.701 1.113 1.113 0 0 0-1.113-1.554.55.55 0 0 0 0-.66v5.775h.234c-.05.052-.095.108-.137.166a2.494 2.494 0 0 1-.097.123v1.375c.263.21.585.335.921.357.591 0 1.279-.33 1.375-.784a1.623 1.623 0 0 0-1.1-1.581Zm.64-4.34a.894.894 0 0 1-.131-.651.88.88 0 0 1 .935-.784 1.03 1.03 0 0 1 .756 1.114.907.907 0 0 1-1.017.701.894.894 0 0 1-.543-.38Zm60.754 13.608a1.512 1.512 0 0 0-.907-1.76 1.664 1.664 0 0 0-1.898 1.237 1.17 1.17 0 0 0 .811 1.526 1.496 1.496 0 0 0 1.994-1.003Zm-9.734 3.548c-.449-.253-.875-.494-.785-1.046a.84.84 0 0 1 .564-.619A1.375 1.375 0 0 1 78.65 55a1.208 1.208 0 0 1 1.65-.605.84.84 0 0 1 .605 1.045 2.022 2.022 0 0 1-1.155 1.073.34.34 0 0 1 .082.15c.206.58-.193.852-.591 1.124l-.165.114-.042-.024-.053-.031Zm21.394-.468a.547.547 0 0 0-.22-.55c-.138-.083-.646-.096-.701.11a.55.55 0 0 0 .316.522c.179.055.605.124.605-.082Zm-2.956-3.41c.398.069.412.508.288.825-.082.316-.398.564-1.003.316a2.84 2.84 0 0 0-.06-.228c-.062-.22-.137-.486-.078-.624.083-.193.454-.357.853-.289Zm6.325 3.781a.472.472 0 0 0-.234-.591.513.513 0 0 0-.723.28.516.516 0 0 0 .042.425.53.53 0 0 0 .351.244.521.521 0 0 0 .564-.358Zm2.224-2.268a.676.676 0 0 1 .292-.014c.069.013.247.274.151.426l-.041.07c-.103.177-.273.47-.536.315a.483.483 0 0 1-.124-.66.673.673 0 0 1 .258-.137ZM74.882 55a.769.769 0 0 0 .385-1.059c-.123-.247-.48-.564-.728-.55-.619 0-.839.523-.908 1.128l.007.006c.328.301.712.653 1.244.475Zm-1.388-11.179c-.385.151-1.169-.247-.949-.921a.743.743 0 0 1 1.293-.041.812.812 0 0 1-.344.962Zm3.671 1.169a1.128 1.128 0 0 0-1.375.234c-.271.265-.51.56-.715.88h-.564a1.76 1.76 0 0 0-1.553 1.127 2.022 2.022 0 0 0 .59 1.87.976.976 0 0 0 .716.248 1.567 1.567 0 0 0 1.553-1.609v-.564c.127 0 .25.008.37.016.234.015.458.03.675-.016.647 0 .894-.261.963-.88a1.376 1.376 0 0 0-.66-1.306Zm16.761 10.45c.44-.825.853-.921 1.65-.44a.853.853 0 0 1 .427.797c-.042.413-.18.812-.647.812a2.998 2.998 0 0 0-.316.123c-.22 1.692-1.045 2.132-2.324 1.156-.467.453-.935.508-1.375 0 .179-1.087.372-1.155 1.554-.62l.142-.243c.276-.474.511-.878.889-1.585ZM91.7 48.909a1.083 1.083 0 0 0-.811.233c-.427.523-.152.99.357 1.472.084-.03.17-.055.253-.08.427-.13.824-.25.847-.8a.756.756 0 0 0-.646-.825Zm-49.35 3.107c-.179-.014-.715-.22-.619-.591.11-.371.619-.371.798-.33a.55.55 0 0 1 .426.564c-.041.357-.426.371-.605.357Zm11.866-3.891a.825.825 0 0 0-.632.454.55.55 0 0 0 .495.728c.233 0 .866-.082.907-.605.042-.522-.563-.577-.77-.577Zm-3.011 9.57c-.082-.234-.014-.715.151-.811a1.8 1.8 0 0 0 .908-.784c.041-.179.247-.179.357-.179.413.124.468.564.413.715-.02.054-.05.109-.08.165-.055.103-.113.21-.113.316a1.223 1.223 0 0 1 .66.99c-.014.344-.715.77-1.127.77a.922.922 0 0 1-.688-.715 1.06 1.06 0 0 1-.481-.467Zm3.699-3.52a.647.647 0 0 0 .481.853h.096c.207.238.48.41.784.495a1.21 1.21 0 0 0 1.306-.62 2.02 2.02 0 0 0-.701-1.883 1.375 1.375 0 0 0-1.279.619.62.62 0 0 0-.687.536ZM29.002 31.838a.963.963 0 0 1 .67-.213.949.949 0 0 1 .84 1.017.894.894 0 0 1-.936.784 1.06 1.06 0 0 1-.921-.976.963.963 0 0 1 .347-.612Zm21.53 21.333a1.224 1.224 0 0 0-1.376.647.866.866 0 0 0 .592 1.072.977.977 0 0 0 1.168-.426c.22-.399-.041-1.197-.385-1.293h.001Zm-1.238 6.683c.206-.083.687-.138.825 0a1.91 1.91 0 0 0 1.045.618c.11.014.261.207.261.303-.027.413-.192.578-.578.578a7.185 7.185 0 0 1-1.375-.234c-.206-.069-.522-.316-.522-.495.01-.292.133-.569.344-.77ZM58.355 49.5a1.018 1.018 0 0 0-1.114.578c-.261.838-.096 1.512.426 1.677a1.512 1.512 0 0 0 1.554-.88 1.5 1.5 0 0 0-.866-1.375Zm1.99 2.892c.142-.042.285-.085.416-.142a1.375 1.375 0 0 1 1.252.303 1.127 1.127 0 0 1 .44 1.072 1.376 1.376 0 0 1-.936 1.059 1.844 1.844 0 0 1-1.54-.344c-.219-.18-.272-.366-.321-.539a1.489 1.489 0 0 0-.063-.19.84.84 0 0 1 0-.756c.106-.27.421-.364.752-.463Zm-4.809-1.256a.44.44 0 0 0 .413.371.66.66 0 0 0 .495-.467c0-.206-.303-.358-.509-.358-.206 0-.44.193-.399.454Zm2.136 5.613a1.527 1.527 0 0 1 .174-1.075 1.994 1.994 0 0 1 2.407-.591 1.663 1.663 0 0 1 .247 2.323 1.377 1.377 0 0 1-2.241.261 1.527 1.527 0 0 1-.587-.918Zm-7.828-6.534a.66.66 0 0 0-.894.44.606.606 0 0 0 .33.839.647.647 0 0 0 .949-.248.757.757 0 0 0-.385-1.031Zm6.448-3.121c.097-.248.344-.248.523-.248.096 0 .509.207.358.482-.126.228-.385.21-.564.197a1.213 1.213 0 0 0-.096-.005.317.317 0 0 1-.221-.426Zm-1.003-2.585c-.248.508 0 1.265.426 1.375.426.11 1.375-1.004 1.169-1.485-.206-.482-1.348-.399-1.595.11ZM32.065 40.37a.62.62 0 0 0 .578.358c.206 0 .274-.386.22-.578-.056-.192-.33-.371-.537-.275a.44.44 0 0 0-.261.495Zm-2.14-4.753a.81.81 0 0 1 .614-.046c.572.149.582.574.593 1.038.003.093.005.188.012.282-.839.385-1.238.427-1.513 0a1.044 1.044 0 0 1-.11-.811.81.81 0 0 1 .405-.463h-.001Zm1.205 11.326c0 .398.124.715.495.797a4.88 4.88 0 0 0 2.874-.083 1.51 1.51 0 0 0 .371-.274 1.087 1.087 0 0 0-.633-1.884h-.11a1.03 1.03 0 0 0 .18-.427.797.797 0 0 0-.785-.907.755.755 0 0 0-.893.66 1.5 1.5 0 0 0 .11.591h-.316a1.704 1.704 0 0 0-1.293 1.527Zm4.473-11.346a1.47 1.47 0 0 1 1-.342c.742.027 1.512 1.155 1.36 2.063a1.253 1.253 0 0 1-1.498 1.03 1.58 1.58 0 0 1-1.375-1.828c.05-.36.234-.69.513-.923Zm2.608 8.83c.138.357 1.375.535 1.54 0a.866.866 0 0 0-.357-1.073c-.481-.124-1.32.716-1.183 1.073Zm2.187 8.45a1.25 1.25 0 0 1 .536-.008c.564.041 1.155.632 1.1 1.169a1.76 1.76 0 0 1-1.691 1.375c-.51 0-.908-.688-.908-1.375a1.25 1.25 0 0 1 .963-1.161Zm22.398-2.937a.894.894 0 0 0-1.072.399.753.753 0 0 0 .357 1.059.88.88 0 0 0 1.073-.413.728.728 0 0 0-.358-1.045ZM39.627 32.986c-.082-.151-.082-.756.165-.839a.77.77 0 0 1 .702.358.688.688 0 0 1-.22.632.673.673 0 0 1-.647-.151Zm-2.062 16.157c-.412 0-.921.48-1.045 1.264.033.034.07.08.112.133.113.143.257.326.438.376a1 1 0 0 0 .289 0c.165.097.398 0 .577-.206a.838.838 0 0 0 .385-.495 1.058 1.058 0 0 0-.756-1.073v.001Zm6.29 6.068c.127-.25.333-.449.585-.569.32-.143.65-.258.99-.343a1.64 1.64 0 0 1 .468 2.269 1.226 1.226 0 0 1-.784.508 1.375 1.375 0 0 1-1.375-1.059 1.265 1.265 0 0 1 .116-.806Z",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("path", {
    fill: "#77E5E0",
    d: "M162.085 56.072H50.999V96.87h111.086V56.072Z",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("path", {
    css: (0, _react2.css)`
          fill: ${euiTheme.colors.fullShade};
        `,
    d: "M43.574 36.575a8.91 8.91 0 1 1 0 17.82 8.91 8.91 0 0 1 0-17.82ZM23.98 103.166h14.946v14.947H23.98v-14.947Zm45.306-34.072L59.14 85.388h20.295L69.286 69.094Zm54.288 4.224a2.9 2.9 0 0 1 2.197-.292 2.902 2.902 0 0 1 1.898 3.589l-3.96 13.516-4.125 12.691c-2.186 7.467-10.326 11.647-18.576 9.227-5.17-1.513-11.564-7.109-12.692-11.592l-3.575-16.156a3.066 3.066 0 0 1 1.953-3.712 2.75 2.75 0 0 1 3.52 1.939l2.062 6.874.207-.715 1.663-5.65 5.541-19.168a2.867 2.867 0 0 1 4.069-1.744 2.86 2.86 0 0 1 1.432 3.339l-5.212 17.792 2.475.715 6.174-21.134a2.867 2.867 0 0 1 4.539-1.438 2.846 2.846 0 0 1 1.057 1.92c.041.374.009.752-.096 1.114l-6.242 21.133 2.475.715L115.5 68.53a2.867 2.867 0 0 1 4.539-1.438 2.846 2.846 0 0 1 1.057 1.92c.041.374.009.752-.096 1.113l-5.225 17.751 2.475.715 3.974-13.516c.2-.742.685-1.373 1.35-1.757Z",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("path", {
    css: (0, _react2.css)`
          fill: ${euiTheme.colors.fullShade};
          animation: ${pulseArrow} 5s ease-in-out 0s infinite normal forwards;
          .domDroppable--hover & {
            animation: ${pulseContinuous} 1.5s ease-in-out 0s infinite normal forwards !important;
          }
        `,
    d: "M84.688 156.577v-31.021c0-1.17.853-2.118 1.906-2.118s1.906.948 1.906 2.118v31.021l15.617-15.617a1.912 1.912 0 0 1 2.662.034 1.912 1.912 0 0 1 .034 2.662l-16.175 16.175a5.696 5.696 0 0 1-3.525 1.652c-.338.107-.7.107-1.039 0a5.699 5.699 0 0 1-3.524-1.652l-16.175-16.175a1.909 1.909 0 0 1 1.358-3.22 1.91 1.91 0 0 1 1.338.524l15.617 15.617Z",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }));
};
exports.DropIllustration = DropIllustration;
const pulseArrow = (0, _react2.keyframes)`
  0% {
    transform: translateY(0%);
  }

  65% {
    transform: translateY(0%);
  }

  72% {
    transform: translateY(10%);
  }

  79% {
    transform: translateY(7%);
  }

  86% {
    transform: translateY(10%);
  }

  95% {
    transform: translateY(0);
  }
`;
const pulseContinuous = (0, _react2.keyframes)`
  0% {
    transform: translateY(10%);
  }
  25% {
    transform: translateY(15%);
  }
  50% {
    transform: translateY(10%);
  }
  75% {
    transform: translateY(15%);
  }
  100% { 
    transform: translateY(10%);
  }
`;