"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CAI_ACTIVITY_SYNC_TYPE = exports.CAI_ACTIVITY_SOURCE_INDEX = exports.CAI_ACTIVITY_INDEX_VERSION = void 0;
exports.getActivityDestinationIndexAlias = getActivityDestinationIndexAlias;
exports.getActivityDestinationIndexName = getActivityDestinationIndexName;
exports.getCAIActivityBackfillTaskId = exports.getActivitySynchronizationSourceQuery = exports.getActivitySourceQuery = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CAI_ACTIVITY_INDEX_NAME_BASE = '.internal.cases-activity';
function getActivityDestinationIndexName(spaceId, owner) {
  return `${CAI_ACTIVITY_INDEX_NAME_BASE}.${owner}-${spaceId}`.toLowerCase();
}
const CAI_ACTIVITY_INDEX_ALIAS_BASE = '.cases-activity';
function getActivityDestinationIndexAlias(spaceId, owner) {
  return `${CAI_ACTIVITY_INDEX_ALIAS_BASE}.${owner}-${spaceId}`.toLowerCase();
}
const CAI_ACTIVITY_INDEX_VERSION = exports.CAI_ACTIVITY_INDEX_VERSION = 1;
const CAI_ACTIVITY_SYNC_TYPE = exports.CAI_ACTIVITY_SYNC_TYPE = 'cai_activity_sync';
const getActivitySourceQuery = (spaceId, owner) => ({
  bool: {
    filter: [{
      term: {
        type: 'cases-user-actions'
      }
    }, {
      term: {
        namespaces: spaceId
      }
    }, {
      term: {
        'cases-user-actions.owner': owner
      }
    }],
    must: [{
      bool: {
        should: [{
          term: {
            'cases-user-actions.type': 'severity'
          }
        }, {
          term: {
            'cases-user-actions.type': 'delete_case'
          }
        }, {
          term: {
            'cases-user-actions.type': 'category'
          }
        }, {
          term: {
            'cases-user-actions.type': 'status'
          }
        }, {
          term: {
            'cases-user-actions.type': 'tags'
          }
        }],
        minimum_should_match: 1
      }
    }]
  }
});
exports.getActivitySourceQuery = getActivitySourceQuery;
const CAI_ACTIVITY_SOURCE_INDEX = exports.CAI_ACTIVITY_SOURCE_INDEX = _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX;
const CAI_ACTIVITY_BACKFILL_TASK_ID = 'cai_activity_backfill_task';
const getCAIActivityBackfillTaskId = (spaceId, owner) => {
  return `${CAI_ACTIVITY_BACKFILL_TASK_ID}-${owner}-${spaceId}`;
};
exports.getCAIActivityBackfillTaskId = getCAIActivityBackfillTaskId;
const getActivitySynchronizationSourceQuery = (lastSyncAt, spaceId, owner) => {
  const baseQuery = getActivitySourceQuery(spaceId, owner);
  return {
    bool: {
      filter: baseQuery.bool.filter,
      must: [...baseQuery.bool.must, {
        range: {
          'cases-user-actions.created_at': {
            gte: lastSyncAt.toISOString()
          }
        }
      }]
    }
  };
};
exports.getActivitySynchronizationSourceQuery = getActivitySynchronizationSourceQuery;