"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimilarCasesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_similar_cases_columns = require("./use_similar_cases_columns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/similar_cases/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SimilarCasesTable = ({
  cases,
  isLoading,
  onChange,
  pagination
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    columns
  } = (0, _use_similar_cases_columns.useSimilarCasesColumns)();
  const tableRowProps = (0, _react.useCallback)(theCase => ({
    'data-test-subj': `similar-cases-table-row-${theCase.id}`
  }), []);
  return isLoading ? /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        margin-top: ${euiTheme.size.m};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": "similar-cases-table-loading",
    lines: 10,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    onChange: onChange,
    pagination: pagination,
    columns: columns,
    "data-test-subj": "similar-cases-table",
    itemId: "id",
    items: cases,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h3", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 20
        }
      }, i18n.NO_CASES),
      titleSize: "xs",
      body: i18n.NO_CASES_BODY,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }),
    rowProps: tableRowProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }));
};
exports.SimilarCasesTable = SimilarCasesTable;
SimilarCasesTable.displayName = 'SimilarCasesTable';