"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCaseFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var _lodash = require("lodash");
var i18n = _interopRequireWildcard(require("../translations"));
var _form = require("../form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/create/flyout/create_case_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateCaseFlyout = exports.CreateCaseFlyout = /*#__PURE__*/_react.default.memo(({
  afterCaseCreated,
  attachments,
  headerContent,
  initialValue,
  onClose,
  onSuccess,
  observables = []
}) => {
  const handleCancel = onClose || _lodash.noop;
  const handleOnSuccess = onSuccess || _lodash.noop;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const maskProps = (0, _react.useMemo)(() => ({
    style: `z-index: ${euiTheme.levels.flyout + 4}`
  }),
  // we need this flyout to be above the timeline flyout (which has a z-index of 1003)
  [euiTheme.levels.flyout]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: handleCancel,
    "tour-step": "create-case-flyout",
    "aria-label": i18n.CREATE_CASE_LABEL,
    "data-test-subj": "create-case-flyout"
    // EUI TODO: This z-index override of EuiOverlayMask is a workaround, and ideally should be resolved with a cleaner UI/UX flow long-term
    ,
    maskProps: maskProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    "data-test-subj": "create-case-flyout-header",
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 15
    }
  }, i18n.CREATE_CASE_TITLE)), headerContent && headerContent), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: (0, _react2.css)`
              && .euiFlyoutBody__overflow {
                overflow-y: auto;
                overflow-x: hidden;
              }

              && .euiFlyoutBody__overflowContent {
                display: block;
                padding: ${euiTheme.size.l} ${euiTheme.size.l} ${euiTheme.size.xxxxl};
                height: auto;
              }
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                width: 100%;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_form.CreateCaseForm, {
    afterCaseCreated: afterCaseCreated,
    attachments: attachments,
    onCancel: handleCancel,
    onSuccess: handleOnSuccess,
    withSteps: false,
    initialValue: initialValue,
    observables: observables,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 15
    }
  })))));
});
CreateCaseFlyout.displayName = 'CreateCaseFlyout';