"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseViewPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../common/types");
var _navigation = require("../../common/navigation");
var _use_cases_context = require("../cases_context/use_cases_context");
var _case_action_bar = require("../case_action_bar");
var _header_page = require("../header_page");
var _editable_title = require("../header_page/editable_title");
var _use_breadcrumbs = require("../use_breadcrumbs");
var _case_view_activity = require("./components/case_view_activity");
var _case_view_alerts = require("./components/case_view_alerts");
var _case_view_files = require("./components/case_view_files");
var _case_view_observables = require("./components/case_view_observables");
var _metrics = require("./metrics");
var _use_on_refresh_case_view_page = require("./use_on_refresh_case_view_page");
var _use_on_update_field = require("./use_on_update_field");
var _case_view_similar_cases = require("./components/case_view_similar_cases");
var _case_view_events = require("./components/case_view_events");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/case_view/case_view_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getActiveTabId = tabId => {
  if (tabId && Object.values(_types.CASE_VIEW_PAGE_TABS).includes(tabId)) {
    return tabId;
  }
  return _types.CASE_VIEW_PAGE_TABS.ACTIVITY;
};
const CaseViewPage = exports.CaseViewPage = /*#__PURE__*/_react.default.memo(({
  caseData,
  refreshRef,
  ruleDetailsNavigation,
  actionsNavigation,
  showAlertDetails,
  useFetchAlertData,
  onAlertsTableLoaded,
  renderAlertsTable,
  renderEventsTable
}) => {
  const {
    features
  } = (0, _use_cases_context.useCasesContext)();
  const {
    urlParams
  } = (0, _navigation.useUrlParams)();
  const refreshCaseViewPage = (0, _use_on_refresh_case_view_page.useRefreshCaseViewPage)();
  (0, _use_breadcrumbs.useCasesTitleBreadcrumbs)(caseData.title);
  const activeTabId = getActiveTabId(urlParams === null || urlParams === void 0 ? void 0 : urlParams.tabId);
  const {
    onUpdateField,
    isLoading,
    loadingKey
  } = (0, _use_on_update_field.useOnUpdateField)({
    caseData
  });

  // Set `refreshRef` if needed
  (0, _react.useEffect)(() => {
    let isStale = false;
    if (refreshRef) {
      refreshRef.current = {
        refreshCase: async () => {
          // Do nothing if component (or instance of this render cycle) is stale or it is already loading
          if (isStale || isLoading) {
            return;
          }
          refreshCaseViewPage();
        }
      };
      return () => {
        isStale = true;
        refreshRef.current = null;
      };
    }
  }, [isLoading, refreshRef, refreshCaseViewPage]);
  const onSubmitTitle = (0, _react.useCallback)(newTitle => onUpdateField({
    key: 'title',
    value: newTitle
  }), [onUpdateField]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    border: false,
    "data-test-subj": "case-view-title",
    titleNode: /*#__PURE__*/_react.default.createElement(_editable_title.EditableTitle, {
      key: caseData.id,
      isLoading: isLoading && loadingKey === 'title',
      title: caseData.title,
      onSubmit: onSubmitTitle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 13
      }
    }),
    title: caseData.title,
    incrementalId: caseData.incrementalId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_case_action_bar.CaseActionBar, {
    caseData: caseData,
    isLoading: isLoading && (loadingKey === 'status' || loadingKey === 'settings'),
    onUpdateField: onUpdateField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_metrics.CaseViewMetrics, {
    "data-test-subj": "case-view-metrics",
    caseId: caseData.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `case-view-tab-content-${activeTabId}`,
    alignItems: "baseline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, activeTabId === _types.CASE_VIEW_PAGE_TABS.ACTIVITY && /*#__PURE__*/_react.default.createElement(_case_view_activity.CaseViewActivity, {
    ruleDetailsNavigation: ruleDetailsNavigation,
    caseData: caseData,
    actionsNavigation: actionsNavigation,
    showAlertDetails: showAlertDetails,
    useFetchAlertData: useFetchAlertData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  }), activeTabId === _types.CASE_VIEW_PAGE_TABS.ALERTS && features.alerts.enabled && /*#__PURE__*/_react.default.createElement(_case_view_alerts.CaseViewAlerts, {
    caseData: caseData,
    renderAlertsTable: renderAlertsTable,
    onAlertsTableLoaded: onAlertsTableLoaded,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }), activeTabId === _types.CASE_VIEW_PAGE_TABS.EVENTS && features.events.enabled && /*#__PURE__*/_react.default.createElement(_case_view_events.CaseViewEvents, {
    caseData: caseData,
    renderEventsTable: renderEventsTable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 13
    }
  }), activeTabId === _types.CASE_VIEW_PAGE_TABS.FILES && /*#__PURE__*/_react.default.createElement(_case_view_files.CaseViewFiles, {
    caseData: caseData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 57
    }
  }), activeTabId === _types.CASE_VIEW_PAGE_TABS.OBSERVABLES && /*#__PURE__*/_react.default.createElement(_case_view_observables.CaseViewObservables, {
    isLoading: false,
    caseData: caseData,
    onUpdateField: onUpdateField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }), activeTabId === _types.CASE_VIEW_PAGE_TABS.SIMILAR_CASES && /*#__PURE__*/_react.default.createElement(_case_view_similar_cases.CaseViewSimilarCases, {
    caseData: caseData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  })));
});
CaseViewPage.displayName = 'CaseViewPage';