"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.traceSamplesTab = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _distribution = require("./distribution");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/trace_samples_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TraceSamplesTab({
  selectSampleFromChartSelection,
  clearChartSelection,
  sampleRangeFrom,
  sampleRangeTo,
  traceSamplesFetchResult
}) {
  return /*#__PURE__*/_react.default.createElement(_distribution.TransactionDistribution, {
    onChartSelection: selectSampleFromChartSelection,
    onClearSelection: clearChartSelection,
    selection: sampleRangeFrom !== undefined && sampleRangeTo !== undefined ? [sampleRangeFrom, sampleRangeTo] : undefined,
    traceSamplesFetchResult: traceSamplesFetchResult,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  });
}
const traceSamplesTab = exports.traceSamplesTab = {
  dataTestSubj: 'apmTraceSamplesTabButton',
  key: 'traceSamples',
  label: _i18n.i18n.translate('xpack.apm.transactionDetails.tabs.traceSamplesLabel', {
    defaultMessage: 'Trace samples'
  }),
  component: TraceSamplesTab
};