"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiagnosticFlyout = DiagnosticFlyout;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _lodash = require("lodash");
var _download_json = require("../../../../utils/download_json");
var _diagnostic_configuration_form = require("./diagnostic_configuration_form");
var _diagnostic_results = require("./diagnostic_results");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
var _technical_preview_badge = require("../../../shared/technical_preview_badge");
var _get_service_map_nodes = require("../../../../../common/service_map/get_service_map_nodes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_map/diagnostic_tool/diagnostic_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function checkForForbiddenServiceNames(form) {
  if (!(form !== null && form !== void 0 && form.destinationNode) || !form.sourceNode) return false;
  if (_get_service_map_nodes.FORBIDDEN_SERVICE_NAMES.includes(form.destinationNode) || _get_service_map_nodes.FORBIDDEN_SERVICE_NAMES.includes(form.sourceNode)) {
    return true;
  }
  return false;
}
function DiagnosticFlyout({
  onClose,
  isOpen,
  selectedNode
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/service-map', '/service-map', '/mobile-services/{serviceName}/service-map');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    services: {
      notifications
    }
  } = (0, _public.useKibana)();
  const [data, setData] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [form, setFormState] = (0, _react.useState)({
    sourceNode: selectedNode.id,
    destinationNode: undefined,
    traceId: undefined,
    isValid: false
  });
  const handleSelectionUpdate = (0, _react.useCallback)(({
    field,
    value
  }) => {
    setFormState(prev => {
      const updated = {
        ...prev,
        [field]: value
      };
      updated.isValid = !!(updated.sourceNode && updated.destinationNode);
      return updated;
    });
    setData(undefined);
  }, []);
  const hasForbiddenNames = (0, _react.useMemo)(() => checkForForbiddenServiceNames(form), [form]);
  const handleRunDiagnostic = async () => {
    setIsLoading(true);
    try {
      if (start && end && form.sourceNode && form.destinationNode) {
        const response = await (0, _create_call_apm_api.callApmApi)('POST /internal/apm/diagnostics/service-map', {
          params: {
            body: {
              start,
              end,
              destinationNode: form.destinationNode,
              sourceNode: form.sourceNode,
              traceId: form.traceId
            }
          },
          signal: null
        });
        setData(response);
      } else {
        setIsLoading(false);
      }
    } catch (error) {
      notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.apm.diagnosticFlyout.errorTitle', {
          defaultMessage: 'Failed to run diagnostic'
        }),
        text: _i18n.i18n.translate('xpack.apm.diagnosticFlyout.errorMessage', {
          defaultMessage: 'An error occurred while running the diagnostic. Please try again.'
        })
      });
      setData(undefined);
    } finally {
      setIsLoading(false);
    }
  };
  if (!isOpen) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutResizable, {
    ownFocus: true,
    onClose: onClose,
    size: "m",
    style: {
      zIndex: 1001
    },
    maxWidth: 1000,
    "data-test-subj": "diagnosticFlyout",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "baseline",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticFlyout.title', {
    defaultMessage: 'Diagnostic tool'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    style: {
      overflowY: 'auto',
      maxHeight: 'calc(100vh - 200px)',
      padding: euiTheme.size.base
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_diagnostic_configuration_form.DiagnosticConfigurationForm, {
    sourceNode: form.sourceNode,
    onSelectionUpdate: handleSelectionUpdate,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }), hasForbiddenNames && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticFlyout.forbiddenServiceNamesTitle', {
      defaultMessage: 'Reserved service names detected'
    }),
    color: "warning",
    iconType: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticFlyout.forbiddenServiceNamesMessage', {
    defaultMessage: 'The following reserved words cannot be used in the service map: {forbiddenNames}. These are reserved keywords that may cause issues with service map functionality.',
    values: {
      forbiddenNames: _get_service_map_nodes.FORBIDDEN_SERVICE_NAMES.map(name => `"${name}"`).join(', ')
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticFlyout.forbiddenServiceNamesSolution', {
    defaultMessage: 'Solution: Please use different service names that do not contain these reserved words.'
  })))), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  }) : data ? /*#__PURE__*/_react.default.createElement(_diagnostic_results.DiagnosticResults, {
    data: data,
    sourceNode: form === null || form === void 0 ? void 0 : form.sourceNode,
    destinationNode: form === null || form === void 0 ? void 0 : form.destinationNode,
    traceId: form === null || form === void 0 ? void 0 : form.traceId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 11
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !form.isValid || isLoading,
    "data-test-subj": "apmDiagnosticRunButton",
    onClick: handleRunDiagnostic,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.diagnosticFlyout.closeButtonLabel', {
    defaultMessage: 'Run diagnostic'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "diagnosticFlyoutDownloadReportButton",
    iconType: "download",
    isDisabled: !form.isValid || isLoading || (0, _lodash.isEmpty)(data),
    onClick: () => (0, _download_json.downloadJson)({
      fileName: `diagnostic-tool-apm-service-map-${(0, _moment.default)(Date.now()).format('YYYYMMDDHHmmss')}.json`,
      data: {
        filters: {
          rangeFrom,
          rangeTo,
          sourceNode: form.sourceNode,
          destinationNode: form.destinationNode,
          traceId: form.traceId
        },
        analysis: data === null || data === void 0 ? void 0 : data.analysis,
        elasticsearchResponses: data === null || data === void 0 ? void 0 : data.elasticsearchResponses
      }
    }),
    fill: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.storageExplorer.downloadReport', {
    defaultMessage: 'Download report'
  })))));
}