"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmAgentCommands = getApmAgentCommands;
exports.getApmAgentHighlightLang = getApmAgentHighlightLang;
exports.getApmAgentLineNumbers = getApmAgentLineNumbers;
exports.getApmAgentVariables = getApmAgentVariables;
var _mustache = _interopRequireDefault(require("mustache"));
var _java = require("./java");
var _node = require("./node");
var _django = require("./django");
var _flask = require("./flask");
var _rails = require("./rails");
var _rack = require("./rack");
var _go = require("./go");
var _dotnet = require("./dotnet");
var _php = require("./php");
var _shared_hints = require("./shared_hints");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const apmAgentCommandsMap = {
  java: _java.java,
  node: _node.node,
  django: _django.django,
  flask: _flask.flask,
  rails: _rails.rails,
  rack: _rack.rack,
  go: _go.go,
  dotnet: _dotnet.dotnet,
  php: _php.php
};
const apmAgentVariablesMap = secretToken => ({
  java: (0, _java.javaVariables)(secretToken),
  node: (0, _node.nodeVariables)(secretToken),
  django: (0, _django.djangoVariables)(secretToken),
  flask: (0, _flask.flaskVariables)(secretToken),
  rails: (0, _rails.railsVariables)(secretToken),
  rack: (0, _rack.rackVariables)(secretToken),
  go: (0, _go.goVariables)(secretToken),
  dotnet: (0, _dotnet.dotnetVariables)(secretToken),
  php: (0, _php.phpVariables)(secretToken)
});
const apmAgentLineNumbersMap = apiKey => ({
  java: (0, _java.javaLineNumbers)(apiKey),
  node: (0, _node.nodeLineNumbers)(),
  django: (0, _django.djangoLineNumbers)(),
  flask: (0, _flask.flaskLineNumbers)(),
  rails: (0, _rails.railsLineNumbers)(),
  rack: (0, _rack.rackLineNumbers)(),
  go: (0, _go.goLineNumbers)(),
  dotnet: (0, _dotnet.dotnetLineNumbers)(),
  php: (0, _php.phpLineNumbers)()
});
const apmAgentHighlightLangMap = {
  java: _java.javaHighlightLang,
  node: _node.nodeHighlightLang,
  django: _django.djangoHighlightLang,
  flask: _flask.flaskHighlightLang,
  rails: _rails.railsHighlightLang,
  rack: _rack.rackHighlightLang,
  go: _go.goHighlightLang,
  dotnet: _dotnet.dotnetHighlightLang,
  php: _php.phpHighlightLang
};
function getApmAgentCommands({
  variantId,
  apmServerUrl,
  secretToken,
  apiKey
}) {
  const commands = apmAgentCommandsMap[variantId];
  if (!commands) {
    return '';
  }
  return _mustache.default.render(commands, {
    apmServerUrl,
    secretToken,
    apiKey,
    serviceNameHint: _shared_hints.serviceNameHint,
    serviceEnvironmentHint: _shared_hints.serviceEnvironmentHint,
    serverUrlHint: _shared_hints.serverUrlHint,
    secretTokenHint: _shared_hints.secretTokenHint,
    apiKeyHint: _shared_hints.apiKeyHint
  });
}
function getApmAgentVariables(variantId, secretToken) {
  return apmAgentVariablesMap(secretToken)[variantId];
}
function getApmAgentLineNumbers(variantId, apiKey) {
  return apmAgentLineNumbersMap(apiKey)[variantId];
}
function getApmAgentHighlightLang(variantId) {
  return apmAgentHighlightLangMap[variantId];
}