"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisContent = exports.DEFAULT_SEARCH_QUERY = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _aiopsLogRateAnalysis = require("@kbn/aiops-log-rate-analysis");
var _state = require("@kbn/aiops-log-rate-analysis/state");
var _constants = require("@kbn/aiops-common/constants");
var _document_count_content = require("../../document_count_content/document_count_content");
var _log_rate_analysis_results = require("../log_rate_analysis_results");
var _use_aiops_app_context = require("../../../hooks/use_aiops_app_context");
var _log_rate_analysis_attachments_menu = require("./log_rate_analysis_attachments_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072200945951588/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_rate_analysis/log_rate_analysis_content/log_rate_analysis_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_SEARCH_QUERY = exports.DEFAULT_SEARCH_QUERY = {
  match_all: {}
};
const DEFAULT_SEARCH_BAR_QUERY = {
  bool: {
    filter: [],
    must: [{
      match_all: {}
    }],
    must_not: []
  }
};
const LogRateAnalysisContent = ({
  esSearchQuery = DEFAULT_SEARCH_QUERY,
  barColorOverride,
  barHighlightColorOverride,
  onAnalysisCompleted,
  onWindowParametersChange
}) => {
  var _documentCountStats$c;
  const {
    embeddingOrigin
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const dispatch = (0, _state.useAppDispatch)();
  const isRunning = (0, _state.useAppSelector)(s => s.stream.isRunning);
  const significantItems = (0, _state.useAppSelector)(s => s.logRateAnalysisResults.significantItems);
  const significantItemsGroups = (0, _state.useAppSelector)(s => s.logRateAnalysisResults.significantItemsGroups);
  const loaded = (0, _state.useAppSelector)(s => s.logRateAnalysisResults.loaded);
  const analysisType = (0, _state.useAppSelector)(s => s.logRateAnalysis.analysisType);
  const windowParameters = (0, _state.useAppSelector)(s => s.logRateAnalysis.chartWindowParameters);

  // Window parameters stored in the url state use this components
  // `initialAnalysisStart` prop to set the initial params restore from url state.
  // To avoid a loop with window parameters being passed around on load,
  // the following ref and useEffect are used to check wether it's safe to call
  // the `onWindowParametersChange` callback.
  const windowParametersTouched = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    // Don't continue if window parameters were not touched yet.
    // Because they can be reset to `undefined` at a later stage again when a user
    // clears the selections, we cannot rely solely on checking if they are
    // `undefined`, we need the additional ref to update on the first change.
    if (!windowParametersTouched.current && windowParameters === undefined) {
      return;
    }
    windowParametersTouched.current = true;
    if (onWindowParametersChange) {
      onWindowParametersChange(windowParameters, true);
    }
  }, [onWindowParametersChange, windowParameters]);

  // Checks if `esSearchQuery` is the default empty query passed on from the search bar
  // and if that's the case fall back to a simpler match all query.
  const searchQuery = (0, _react.useMemo)(() => (0, _lodash.isEqual)(esSearchQuery, DEFAULT_SEARCH_BAR_QUERY) ? DEFAULT_SEARCH_QUERY : esSearchQuery, [esSearchQuery]);
  const {
    autoRunAnalysis,
    documentStats,
    earliest,
    latest,
    isBrushCleared
  } = (0, _state.useAppSelector)(s => s.logRateAnalysis);
  const {
    documentCountStats
  } = documentStats;
  function clearSelectionHandler() {
    dispatch((0, _state.setGroupResults)(false));
    dispatch((0, _state.clearSelection)());
    dispatch((0, _state.clearAllRowState)());
  }
  const barStyle = {
    rect: {
      opacity: 1,
      fill: (0, _aiopsLogRateAnalysis.useLogRateAnalysisBarColors)().barHighlightColor
    }
  };

  // Used to highlight an auto-detected change point in the date histogram.
  const barStyleAccessor = isBrushCleared && documentCountStats !== null && documentCountStats !== void 0 && documentCountStats.changePoint ? (d, g) => {
    return g.specId === 'document_count' && documentCountStats !== null && documentCountStats !== void 0 && documentCountStats.changePoint && Number(d.x) > documentCountStats.changePoint.startTs && Number(d.x) < documentCountStats.changePoint.endTs ? barStyle : null;
  } : undefined;
  const triggerAnalysisForManualSelection = (0, _react.useCallback)(() => {
    dispatch((0, _state.setAutoRunAnalysis)(true));
  }, [dispatch]);
  const triggerAnalysisForChangePoint = (0, _react.useCallback)(() => {
    if (documentCountStats) {
      const {
        interval,
        timeRangeEarliest,
        timeRangeLatest,
        changePoint
      } = documentCountStats;
      if (changePoint && interval && timeRangeEarliest && timeRangeLatest) {
        const wp = (0, _aiopsLogRateAnalysis.getWindowParametersForTrigger)(changePoint.startTs, interval, timeRangeEarliest, timeRangeLatest, changePoint);
        const snapTimestamps = (0, _aiopsLogRateAnalysis.getSnappedTimestamps)(timeRangeEarliest, timeRangeLatest, interval);
        const wpSnap = (0, _aiopsLogRateAnalysis.getSnappedWindowParameters)(wp, snapTimestamps);
        triggerAnalysisForManualSelection();
        dispatch((0, _state.setInitialAnalysisStart)(wpSnap));
      }
    }
  }, [documentCountStats, dispatch, triggerAnalysisForManualSelection]);
  (0, _react.useEffect)(() => {
    if (!isRunning && loaded === 1 && onAnalysisCompleted) {
      onAnalysisCompleted({
        analysisType,
        significantItems,
        significantItemsGroups
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isRunning, loaded]);
  const showDocumentCountContent = documentCountStats !== undefined;
  const showLogRateAnalysisResults = autoRunAnalysis && earliest !== undefined && latest !== undefined && windowParameters !== undefined;
  const showNoAutoRunEmptyPrompt = !autoRunAnalysis && earliest !== undefined && latest !== undefined && windowParameters !== undefined;
  const showSpikeDetectedEmptyPrompt = windowParameters === undefined && (documentCountStats === null || documentCountStats === void 0 ? void 0 : documentCountStats.changePoint);
  const showDefaultEmptyPrompt = windowParameters === undefined && (documentCountStats === null || documentCountStats === void 0 ? void 0 : documentCountStats.changePoint) === undefined;
  const changePointType = documentCountStats === null || documentCountStats === void 0 ? void 0 : (_documentCountStats$c = documentCountStats.changePoint) === null || _documentCountStats$c === void 0 ? void 0 : _documentCountStats$c.type;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: embeddingOrigin === _constants.AIOPS_EMBEDDABLE_ORIGIN.DASHBOARD ? 'none' : 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 5
    }
  }, showDocumentCountContent && /*#__PURE__*/_react.default.createElement(_document_count_content.DocumentCountContent, {
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride,
    barStyleAccessor: barStyleAccessor,
    attachmentsMenu: /*#__PURE__*/_react.default.createElement(_log_rate_analysis_attachments_menu.LogRateAnalysisAttachmentsMenu, {
      windowParameters: windowParameters,
      showLogRateAnalysisResults: showLogRateAnalysisResults,
      significantItems: significantItems,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  }), showLogRateAnalysisResults && /*#__PURE__*/_react.default.createElement(_log_rate_analysis_results.LogRateAnalysisResults, {
    onReset: clearSelectionHandler,
    searchQuery: searchQuery,
    barColorOverride: barColorOverride,
    barHighlightColorOverride: barHighlightColorOverride,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 9
    }
  }), showNoAutoRunEmptyPrompt && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    color: "subdued",
    hasShadow: false,
    hasBorder: false,
    css: {
      minWidth: '100%'
    },
    title: undefined,
    titleSize: "xs",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.noAutoRunPromptBody",
      defaultMessage: "Next you can fine tune the time ranges for baseline and deviation by dragging the handles of the brushes. Once you're ready, click the button 'Run analysis' below.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "aiopsLogRateAnalysisNoAutoRunContentRunAnalysisButton",
      onClick: triggerAnalysisForManualSelection,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.noAutoRunPromptRunAnalysisButton",
      defaultMessage: "Run analysis",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 258,
        columnNumber: 17
      }
    })), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "aiopsClearSelectionBadge",
      onClick: () => clearSelectionHandler(),
      color: "text",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.clearSelectionLabel",
      defaultMessage: "Clear selection",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 17
      }
    }))),
    "data-test-subj": "aiopsChangePointDetectedPrompt",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 9
    }
  }), showSpikeDetectedEmptyPrompt && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    color: "subdued",
    hasShadow: false,
    hasBorder: false,
    css: {
      minWidth: '100%'
    },
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 285,
        columnNumber: 13
      }
    }, changePointType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.SPIKE && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.changePointSpikePromptTitle",
      defaultMessage: "Log rate spike detected",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 17
      }
    }), changePointType === _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.DIP && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.changePointDipPromptTitle",
      defaultMessage: "Log rate dip detected",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 17
      }
    }), changePointType !== _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.SPIKE && changePointType !== _aiopsLogRateAnalysis.LOG_RATE_ANALYSIS_TYPE.DIP && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.changePointOtherPromptTitle",
      defaultMessage: "Log rate change point detected",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 300,
        columnNumber: 19
      }
    })),
    titleSize: "xs",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 310,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.changePointPromptBody",
      defaultMessage: "The log rate analysis feature identifies statistically significant field/value combinations that contribute to a log rate spike or dip. To analyse the area highlighted in the chart, click the button below. For custom analysis of other areas, start by clicking on any of the non-highlighted bars in the histogram chart.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 311,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "aiopsLogRateAnalysisContentRunAnalysisButton",
      onClick: triggerAnalysisForChangePoint,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 316,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.changePointPromptRunAnalysisButton",
      defaultMessage: "Run analysis",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 320,
        columnNumber: 17
      }
    }))),
    "data-test-subj": "aiopsChangePointDetectedPrompt",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 9
    }
  }), showDocumentCountContent && showDefaultEmptyPrompt && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    color: "subdued",
    hasShadow: false,
    hasBorder: false,
    css: {
      minWidth: '100%'
    },
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 337,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.emptyPromptTitle",
      defaultMessage: "Start by clicking a spike or dip in the histogram chart.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 338,
        columnNumber: 15
      }
    })),
    titleSize: "xs",
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 346,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.aiops.logRateAnalysis.page.emptyPromptBody",
      defaultMessage: "The log rate analysis feature identifies statistically significant field/value combinations that contribute to a log rate spike or dip.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 347,
        columnNumber: 15
      }
    })),
    "data-test-subj": "aiopsNoWindowParametersEmptyPrompt",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 9
    }
  }));
};
exports.LogRateAnalysisContent = LogRateAnalysisContent;