"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAxiosInstanceWithAuth = void 0;
var _axios = _interopRequireDefault(require("axios"));
var _get_custom_agents = require("./get_custom_agents");
var _before_redirect = require("./before_redirect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAxiosInstanceWithAuth = ({
  authTypeRegistry,
  configurationUtilities,
  logger
}) => {
  return async secrets => {
    let authTypeId;
    try {
      authTypeId = secrets.authType || 'none';

      // throws if auth type is not found
      const authType = authTypeRegistry.get(authTypeId);
      const {
        maxContentLength,
        timeout: settingsTimeout
      } = configurationUtilities.getResponseSettings();
      const axiosInstance = _axios.default.create({
        maxContentLength,
        // should we allow a way for a connector type to specify a timeout override?
        timeout: settingsTimeout,
        beforeRedirect: (0, _before_redirect.getBeforeRedirectFn)(configurationUtilities)
      });

      // create a request interceptor to inject custom http/https agents based on the URL
      axiosInstance.interceptors.request.use(config => {
        if (config.url) {
          const {
            httpAgent,
            httpsAgent
          } = (0, _get_custom_agents.getCustomAgents)(configurationUtilities, logger, config.url,
          // todo - sslOverrides, needed when we support certificate based auth
          {});

          // use httpAgent and httpsAgent and set axios proxy: false, to be able to handle fail on invalid certs
          config.httpAgent = httpAgent;
          config.httpsAgent = httpsAgent;
          config.proxy = false;
        }
        return config;
      });

      // use the registered auth type to configure authentication for the axios instance
      return authType.configure(axiosInstance, secrets);
    } catch (err) {
      var _authTypeId;
      logger.error(`Error getting configured axios instance configured for auth type "${(_authTypeId = authTypeId) !== null && _authTypeId !== void 0 ? _authTypeId : 'unknown'}": ${err.message} `);
      throw err;
    }
  };
};
exports.getAxiosInstanceWithAuth = getAxiosInstanceWithAuth;