/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.promql;

import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.TimestampAware;
import org.elasticsearch.xpack.esql.expression.promql.subquery.Subquery;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.promql.AcrossSeriesAggregate;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.RangeSelector;
import org.elasticsearch.xpack.esql.plan.logical.promql.selector.Selector;

public class PromqlCommand
extends UnaryPlan
implements TelemetryAware,
PostAnalysisVerificationAware,
TimestampAware {
    private final LogicalPlan promqlPlan;
    private final Literal start;
    private final Literal end;
    private final Literal step;
    private final Expression timestamp;

    public PromqlCommand(Source source, LogicalPlan child, LogicalPlan promqlPlan, Literal start, Literal end, Literal step, Expression timestamp) {
        super(source, child);
        this.promqlPlan = promqlPlan;
        this.start = start;
        this.end = end;
        this.step = step;
        this.timestamp = timestamp;
    }

    protected NodeInfo<PromqlCommand> info() {
        return NodeInfo.create((Node)this, PromqlCommand::new, (Object)((Object)this.child()), (Object)((Object)this.promqlPlan()), (Object)this.start(), (Object)this.end(), (Object)this.step(), (Object)this.timestamp());
    }

    @Override
    public PromqlCommand replaceChild(LogicalPlan newChild) {
        return new PromqlCommand(this.source(), newChild, this.promqlPlan(), this.start(), this.end(), this.step(), this.timestamp());
    }

    public PromqlCommand withPromqlPlan(LogicalPlan newPromqlPlan) {
        return new PromqlCommand(this.source(), this.child(), newPromqlPlan, this.start(), this.end(), this.step(), this.timestamp());
    }

    @Override
    public boolean expressionsResolved() {
        return this.promqlPlan.resolved() && this.timestamp.resolved();
    }

    @Override
    public String telemetryLabel() {
        return "PROMQL";
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("serialization not supported");
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("serialization not supported");
    }

    public LogicalPlan promqlPlan() {
        return this.promqlPlan;
    }

    public Literal start() {
        return this.start;
    }

    public Literal end() {
        return this.end;
    }

    public Literal step() {
        return this.step;
    }

    public boolean isInstantQuery() {
        return this.step.value() == null;
    }

    public boolean isRangeQuery() {
        return this.step.value() != null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.child(), this.promqlPlan, this.start, this.end, this.step, this.timestamp});
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            PromqlCommand other = (PromqlCommand)obj;
            return Objects.equals((Object)this.child(), (Object)other.child()) && Objects.equals((Object)this.promqlPlan, (Object)other.promqlPlan) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.step, other.step) && Objects.equals(this.timestamp, other.timestamp);
        }
        return false;
    }

    public String nodeString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nodeName());
        sb.append(" start=[").append(this.start);
        sb.append("] end=[").append(this.end);
        sb.append("] step=[").append(this.step);
        sb.append("] promql=[<>\n");
        sb.append(this.promqlPlan.toString());
        sb.append("\n<>]]");
        return sb.toString();
    }

    @Override
    public void postAnalysisVerification(Failures failures) {
        LogicalPlan p = this.promqlPlan();
        if (!(p instanceof AcrossSeriesAggregate)) {
            failures.add(Failure.fail(p, "only aggregations across timeseries are supported at this time (found [{}])", p.sourceText()));
        }
        p.forEachDown(lp -> {
            RangeSelector rs;
            Duration rangeDuration;
            if (lp instanceof Selector) {
                Selector s = (Selector)((Object)lp);
                if (s.labelMatchers().nameLabel().matcher().isRegex()) {
                    failures.add(Failure.fail(s, "regex label selectors on __name__ are not supported at this time [{}]", s.sourceText()));
                }
                if (s.evaluation() != null) {
                    if (s.evaluation().offset().value() != null && !s.evaluation().offsetDuration().isZero()) {
                        failures.add(Failure.fail(s, "offset modifiers are not supported at this time [{}]", s.sourceText()));
                    }
                    if (s.evaluation().at().value() != null) {
                        failures.add(Failure.fail(s, "@ modifiers are not supported at this time [{}]", s.sourceText()));
                    }
                }
            }
            if (lp instanceof Subquery) {
                failures.add(Failure.fail(lp, "subqueries are not supported at this time [{}]", lp.sourceText()));
            }
            if (this.step().value() != null && lp instanceof RangeSelector && !(rangeDuration = (Duration)(rs = (RangeSelector)((Object)lp)).range().fold(null)).equals(this.step().value())) {
                failures.add(Failure.fail(rs.range(), "the duration for range vector selector [{}] must be equal to the query's step for range queries at this time", new Object[]{rs.range().sourceText()}));
            }
        });
    }

    @Override
    public Expression timestamp() {
        return this.timestamp;
    }
}

