/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.internal;

import java.util.List;
import java.util.function.Function;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.internal.InternalPacks;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public final class UnpackDimension
extends UnaryScalarFunction {
    private final DataType resultType;

    public UnpackDimension(Source source, Expression field, DataType resultType) {
        super(source, field);
        this.resultType = resultType;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("UnpackDimension must be used on the coordinator only");
    }

    @Override
    public DataType dataType() {
        return this.resultType;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new UnpackDimension(this.source(), newChildren.getFirst(), this.resultType);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, UnpackDimension::new, (Object)this.field(), (Object)this.dataType());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return switch (PlannerUtils.toElementType(this.resultType)) {
            case ElementType.NULL -> EvalOperator.CONSTANT_NULL_FACTORY;
            case ElementType.BYTES_REF -> ctx -> new UnpackValuesEvaluator(toEvaluator.apply(this.field).get(ctx), block -> InternalPacks.unpackBytesValues(ctx, block));
            case ElementType.LONG -> ctx -> new UnpackValuesEvaluator(toEvaluator.apply(this.field).get(ctx), block -> InternalPacks.unpackLongValues(ctx, block));
            case ElementType.INT -> ctx -> new UnpackValuesEvaluator(toEvaluator.apply(this.field).get(ctx), block -> InternalPacks.unpackIntValues(ctx, block));
            case ElementType.BOOLEAN -> ctx -> new UnpackValuesEvaluator(toEvaluator.apply(this.field).get(ctx), block -> InternalPacks.unpackBooleanValues(ctx, block));
            default -> throw new IllegalStateException("unsupported element type [" + String.valueOf(this.field.dataType()) + "]");
        };
    }

    record UnpackValuesEvaluator(EvalOperator.ExpressionEvaluator field, Function<BytesRefBlock, Block> unpack) implements EvalOperator.ExpressionEvaluator
    {
        static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(UnpackValuesEvaluator.class);

        public Block eval(Page page) {
            try (Block fieldVal = this.field.eval(page);){
                assert (!fieldVal.doesHaveMultivaluedFields()) : "packed block cannot be multivalued";
                Block block = this.unpack.apply((BytesRefBlock)fieldVal);
                return block;
            }
        }

        @Override
        public String toString() {
            return "UnpackDimension[field=" + String.valueOf(this.field) + "]";
        }

        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED + this.field.baseRamBytesUsed();
        }

        public void close() {
            Releasables.close((Releasable)this.field);
        }
    }
}

