/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMin;

public final class ClampMinBooleanEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ClampMinBooleanEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field;
    private final EvalOperator.ExpressionEvaluator min;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ClampMinBooleanEvaluator(Source source, EvalOperator.ExpressionEvaluator field, EvalOperator.ExpressionEvaluator min, DriverContext driverContext) {
        this.source = source;
        this.field = field;
        this.min = min;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BooleanBlock fieldBlock = (BooleanBlock)this.field.eval(page);){
            BooleanBlock booleanBlock;
            block20: {
                BooleanVector minVector;
                BooleanVector fieldVector;
                BooleanBlock minBlock;
                block18: {
                    BooleanBlock booleanBlock2;
                    block19: {
                        block16: {
                            BooleanBlock booleanBlock3;
                            block17: {
                                minBlock = (BooleanBlock)this.min.eval(page);
                                try {
                                    fieldVector = fieldBlock.asVector();
                                    if (fieldVector != null) break block16;
                                    booleanBlock3 = this.eval(page.getPositionCount(), fieldBlock, minBlock);
                                    if (minBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (minBlock != null) {
                                        try {
                                            minBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                minBlock.close();
                            }
                            return booleanBlock3;
                        }
                        minVector = minBlock.asVector();
                        if (minVector != null) break block18;
                        booleanBlock2 = this.eval(page.getPositionCount(), fieldBlock, minBlock);
                        if (minBlock == null) break block19;
                        minBlock.close();
                    }
                    return booleanBlock2;
                }
                booleanBlock = this.eval(page.getPositionCount(), fieldVector, minVector).asBlock();
                if (minBlock == null) break block20;
                minBlock.close();
            }
            return booleanBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.field.baseRamBytesUsed();
        return baseRamBytesUsed += this.min.baseRamBytesUsed();
    }

    public BooleanBlock eval(int positionCount, BooleanBlock fieldBlock, BooleanBlock minBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            block13: for (int p = 0; p < positionCount; ++p) {
                switch (fieldBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                switch (minBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                boolean field = fieldBlock.getBoolean(fieldBlock.getFirstValueIndex(p));
                boolean min = minBlock.getBoolean(minBlock.getFirstValueIndex(p));
                result.appendBoolean(ClampMin.process(field, min));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, BooleanVector fieldVector, BooleanVector minVector) {
        try (BooleanVector.FixedBuilder result = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean field = fieldVector.getBoolean(p);
                boolean min = minVector.getBoolean(p);
                result.appendBoolean(p, ClampMin.process(field, min));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "ClampMinBooleanEvaluator[field=" + String.valueOf(this.field) + ", min=" + String.valueOf(this.min) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field, this.min});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;
        private final EvalOperator.ExpressionEvaluator.Factory min;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field, EvalOperator.ExpressionEvaluator.Factory min) {
            this.source = source;
            this.field = field;
            this.min = min;
        }

        public ClampMinBooleanEvaluator get(DriverContext context) {
            return new ClampMinBooleanEvaluator(this.source, this.field.get(context), this.min.get(context), context);
        }

        public String toString() {
            return "ClampMinBooleanEvaluator[field=" + String.valueOf(this.field) + ", min=" + String.valueOf(this.min) + "]";
        }
    }
}

