/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.inference;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.inference.InferenceFunction;

public class CompletionFunction
extends InferenceFunction<CompletionFunction> {
    private final Expression inferenceId;
    private final Expression prompt;

    public CompletionFunction(Source source, Expression prompt, Expression inferenceId) {
        super(source, List.of(prompt, inferenceId));
        this.inferenceId = inferenceId;
        this.prompt = prompt;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("doesn't escape the node");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("doesn't escape the node");
    }

    public Expression prompt() {
        return this.prompt;
    }

    @Override
    public Expression inferenceId() {
        return this.inferenceId;
    }

    public boolean foldable() {
        return this.inferenceId.foldable() && this.prompt.foldable();
    }

    public DataType dataType() {
        return this.prompt.dataType() == DataType.NULL ? DataType.NULL : DataType.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution promptResolution = TypeResolutions.isNotNull((Expression)this.prompt, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isFoldable((Expression)this.prompt, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST)).and(TypeResolutions.isType((Expression)this.prompt, DataType::isString, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"string"}));
        if (promptResolution.unresolved()) {
            return promptResolution;
        }
        Expression.TypeResolution inferenceIdResolution = TypeResolutions.isNotNull((Expression)this.inferenceId, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND).and(TypeResolutions.isType((Expression)this.inferenceId, arg_0 -> DataType.KEYWORD.equals(arg_0), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"string"})).and(TypeResolutions.isFoldable((Expression)this.inferenceId, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
        if (inferenceIdResolution.unresolved()) {
            return inferenceIdResolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    @Override
    public TaskType taskType() {
        return TaskType.COMPLETION;
    }

    @Override
    public CompletionFunction withInferenceResolutionError(String inferenceId, String error) {
        return new CompletionFunction(this.source(), this.prompt, (Expression)new UnresolvedAttribute(this.inferenceId().source(), inferenceId, error));
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new CompletionFunction(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, CompletionFunction::new, (Object)this.prompt, (Object)this.inferenceId);
    }

    public String toString() {
        return "COMPLETION(" + String.valueOf(this.prompt) + ", " + String.valueOf(this.inferenceId) + ")";
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompletionFunction completionFunction = (CompletionFunction)((Object)o);
        return Objects.equals(this.inferenceId, completionFunction.inferenceId) && Objects.equals(this.prompt, completionFunction.prompt);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.inferenceId, this.prompt);
    }
}

