/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class EsqlResolveFieldsResponse
extends ActionResponse {
    private static final TransportVersion RESOLVE_FIELDS_RESPONSE_CREATED_TV = TransportVersion.fromName((String)"esql_resolve_fields_response_created");
    public static final TransportVersion RESOLVE_FIELDS_RESPONSE_REMOVED_MIN_TV = TransportVersion.fromName((String)"esql_resolve_fields_response_removed_min_tv");
    public static final TransportVersion RESOLVE_FIELDS_RESPONSE_USED_TV = TransportVersion.fromName((String)"esql_resolve_fields_response_used");
    private final FieldCapabilitiesResponse caps;

    public EsqlResolveFieldsResponse(FieldCapabilitiesResponse caps) {
        this.caps = caps;
    }

    public EsqlResolveFieldsResponse(StreamInput in) throws IOException {
        this.caps = EsqlResolveFieldsResponse.readMinTransportVersion(new FieldCapabilitiesResponse(in), in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.caps.writeTo(out);
        this.writeMinTransportVersion(out);
    }

    private static FieldCapabilitiesResponse readMinTransportVersion(FieldCapabilitiesResponse caps, StreamInput in) throws IOException {
        if (in.getTransportVersion().supports(RESOLVE_FIELDS_RESPONSE_REMOVED_MIN_TV)) {
            return caps;
        }
        if (in.getTransportVersion().supports(RESOLVE_FIELDS_RESPONSE_CREATED_TV) && in.readBoolean()) {
            return caps.withMinTransportVersion(TransportVersion.readVersion((StreamInput)in));
        }
        return caps;
    }

    private void writeMinTransportVersion(StreamOutput out) throws IOException {
        if (out.getTransportVersion().supports(RESOLVE_FIELDS_RESPONSE_REMOVED_MIN_TV)) {
            return;
        }
        if (out.getTransportVersion().supports(RESOLVE_FIELDS_RESPONSE_CREATED_TV)) {
            out.writeBoolean(this.caps.minTransportVersion() != null);
            if (this.caps.minTransportVersion() != null) {
                TransportVersion.writeVersion((TransportVersion)this.caps.minTransportVersion(), (StreamOutput)out);
            }
            return;
        }
    }

    public FieldCapabilitiesResponse caps() {
        return this.caps;
    }
}

