/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.test.RandomObjects;
import org.elasticsearch.test.rest.ObjectPath;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;

public final class XContentTestUtils {
    private XContentTestUtils() {
    }

    public static Map<String, Object> convertToMap(ChunkedToXContent chunkedToXContent) throws IOException {
        return XContentTestUtils.convertToMap(chunkedToXContent, ToXContent.EMPTY_PARAMS);
    }

    public static Map<String, Object> convertToMap(ChunkedToXContent chunkedToXContent, ToXContent.Params params) throws IOException {
        return XContentTestUtils.convertToMap(ChunkedToXContent.wrapAsToXContent((ChunkedToXContent)chunkedToXContent), params);
    }

    public static Map<String, Object> convertToMap(ToXContent part) throws IOException {
        return XContentTestUtils.convertToMap(part, ToXContent.EMPTY_PARAMS);
    }

    public static Map<String, Object> convertToMap(ToXContent part, ToXContent.Params params) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        if (part.isFragment()) {
            builder.startObject();
            part.toXContent(builder, params);
            builder.endObject();
        } else {
            part.toXContent(builder, params);
        }
        return (Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)builder), (boolean)false, (XContentType)builder.contentType()).v2();
    }

    public static BytesReference convertToXContent(Map<String, ?> map, XContentType xContentType) throws IOException {
        try (XContentBuilder builder = XContentFactory.contentBuilder((XContentType)xContentType);){
            builder.map(map);
            BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
            return bytesReference;
        }
    }

    public static String differenceBetweenMapsIgnoringArrayOrder(Map<String, Object> first, Map<String, Object> second) {
        return XContentTestUtils.differenceBetweenMapsIgnoringArrayOrder("", first, second, p -> true);
    }

    public static String differenceBetweenMapsIgnoringArrayOrder(Map<String, Object> first, Map<String, Object> second, Predicate<String> pathFilter) {
        return XContentTestUtils.differenceBetweenMapsIgnoringArrayOrder("", first, second, pathFilter);
    }

    private static String differenceBetweenMapsIgnoringArrayOrder(String path, Map<String, Object> first, Map<String, Object> second, Predicate<String> pathFilter) {
        if (!pathFilter.test(path)) {
            return null;
        }
        if (first.size() != second.size()) {
            return path + ": sizes of the maps don't match: " + first.size() + " != " + second.size();
        }
        for (String key : first.keySet()) {
            String reason = XContentTestUtils.differenceBetweenObjectsIgnoringArrayOrder(path + "/" + key, first.get(key), second.get(key), pathFilter);
            if (reason == null) continue;
            return reason;
        }
        return null;
    }

    private static String differenceBetweenObjectsIgnoringArrayOrder(String path, Object first, Object second, Predicate<String> pathFilter) {
        if (!pathFilter.test(path)) {
            return null;
        }
        if (first == null) {
            if (second == null) {
                return null;
            }
            return path + ": first element is null, the second element is not null";
        }
        if (first instanceof List) {
            if (second instanceof List) {
                ArrayList secondList = new ArrayList((List)second);
                List firstList = (List)first;
                if (firstList.size() == secondList.size()) {
                    Object reason = path + ": no matches found";
                    for (Object firstObj : firstList) {
                        boolean found = false;
                        for (Object secondObj : secondList) {
                            reason = XContentTestUtils.differenceBetweenObjectsIgnoringArrayOrder(path + "/*", firstObj, secondObj, pathFilter);
                            if (reason != null) continue;
                            secondList.remove(secondObj);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        return reason;
                    }
                    if (secondList.isEmpty()) {
                        return null;
                    }
                    return path + ": the second list is not empty";
                }
                return path + ": sizes of the arrays don't match: " + firstList.size() + " != " + secondList.size();
            }
            return path + ": the second element is not an array";
        }
        if (first instanceof Map) {
            if (second instanceof Map) {
                return XContentTestUtils.differenceBetweenMapsIgnoringArrayOrder(path, (Map)first, (Map)second, pathFilter);
            }
            return path + ": the second element is not a map (got " + String.valueOf(second) + ")";
        }
        if (first.equals(second)) {
            return null;
        }
        return path + ": the elements don't match: [" + String.valueOf(first) + "] != [" + String.valueOf(second) + "]";
    }

    public static BytesReference insertRandomFields(XContentType contentType, BytesReference xContent, Predicate<String> excludeFilter, Random random) throws IOException {
        List<String> insertPaths;
        try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)xContent, (XContentType)contentType);){
            parser.nextToken();
            List<String> possiblePaths = XContentTestUtils.getInsertPaths(parser, new ArrayDeque<String>());
            if (excludeFilter == null) {
                insertPaths = possiblePaths;
            } else {
                insertPaths = new ArrayList<String>();
                possiblePaths.stream().filter(excludeFilter.negate()).forEach(insertPaths::add);
            }
        }
        Supplier<Object> value = () -> {
            List randomValues = (List)RandomObjects.randomStoredFieldValues(random, contentType).v1();
            if (random.nextBoolean()) {
                return randomValues.get(0);
            }
            if (random.nextBoolean()) {
                return randomValues.stream().collect(Collectors.toMap(obj -> RandomStrings.randomAsciiOfLength((Random)random, (int)10), obj -> obj));
            }
            return randomValues;
        };
        return BytesReference.bytes((XContentBuilder)XContentTestUtils.insertIntoXContent(contentType.xContent(), xContent, insertPaths, () -> RandomStrings.randomAsciiOfLength((Random)random, (int)10), value));
    }

    static List<String> getInsertPaths(XContentParser parser, Deque<String> currentPath) throws IOException {
        assert (parser.currentToken() == XContentParser.Token.START_OBJECT || parser.currentToken() == XContentParser.Token.START_ARRAY) : "should only be called when new objects or arrays start";
        ArrayList<String> validPaths = new ArrayList<String>();
        if (parser.currentName() != null) {
            currentPath.addLast(parser.currentName().replace(".", "\\."));
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            validPaths.add(String.join((CharSequence)".", currentPath));
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                if (parser.currentToken() != XContentParser.Token.START_OBJECT && parser.currentToken() != XContentParser.Token.START_ARRAY) continue;
                validPaths.addAll(XContentTestUtils.getInsertPaths(parser, currentPath));
            }
        } else if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
            int itemCount = 0;
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                if (parser.currentToken() == XContentParser.Token.START_OBJECT || parser.currentToken() == XContentParser.Token.START_ARRAY) {
                    currentPath.addLast(Integer.toString(itemCount));
                    validPaths.addAll(XContentTestUtils.getInsertPaths(parser, currentPath));
                    currentPath.removeLast();
                }
                ++itemCount;
            }
        }
        if (parser.currentName() != null) {
            currentPath.removeLast();
        }
        return validPaths;
    }

    public static XContentBuilder insertIntoXContent(XContent xContent, BytesReference original, List<String> paths, Supplier<String> key, Supplier<Object> value) throws IOException {
        ObjectPath object = ObjectPath.createFromXContent(xContent, original);
        for (String path : paths) {
            Map insertMap = (Map)object.evaluate(path);
            insertMap.put(key.get(), value.get());
        }
        return object.toXContentBuilder(xContent);
    }

    public static JsonMapView createJsonMapView(InputStream inputStream) {
        Map responseMap = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (InputStream)inputStream, (boolean)true);
        return new JsonMapView(responseMap);
    }

    public static class JsonMapView {
        private final Map<String, Object> map;

        public JsonMapView(Map<String, Object> map) {
            this.map = map;
        }

        public <T> T get(String path) {
            String[] keys = path.split("\\.");
            Object context = this.map;
            for (String key : keys) {
                if (context instanceof Map) {
                    context = context.get(key);
                    continue;
                }
                if (context instanceof List) {
                    context = ((List)context).get(Integer.parseInt(key));
                    continue;
                }
                return null;
            }
            return (T)context;
        }

        public String toString() {
            return "JsonMapView{map=" + String.valueOf(this.map) + "}";
        }
    }
}

