/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorTestCase;
import org.elasticsearch.search.aggregations.InternalAggregation;

public abstract class DateHistogramAggregatorTestCase
extends AggregatorTestCase {
    protected static final String AGGREGABLE_DATE = "aggregable_date";

    protected final <R extends InternalAggregation> void asSubAggTestCase(AggregationBuilder builder, Consumer<R> verify) throws IOException {
        CheckedBiConsumer buildIndex = (iw, dft) -> {
            iw.addDocument(List.of(new SortedNumericDocValuesField(AGGREGABLE_DATE, dft.parse("2020-02-01T00:00:00Z")), new Field("k1", new BytesRef((CharSequence)"a"), (IndexableFieldType)KeywordFieldMapper.Defaults.FIELD_TYPE), new Field("k2", new BytesRef((CharSequence)"a"), (IndexableFieldType)KeywordFieldMapper.Defaults.FIELD_TYPE), new SortedNumericDocValuesField("n", 1L)));
            iw.addDocument(List.of(new SortedNumericDocValuesField(AGGREGABLE_DATE, dft.parse("2020-03-01T00:00:00Z")), new Field("k1", new BytesRef((CharSequence)"a"), (IndexableFieldType)KeywordFieldMapper.Defaults.FIELD_TYPE), new Field("k2", new BytesRef((CharSequence)"a"), (IndexableFieldType)KeywordFieldMapper.Defaults.FIELD_TYPE), new SortedNumericDocValuesField("n", 2L)));
            iw.addDocument(List.of(new SortedNumericDocValuesField(AGGREGABLE_DATE, dft.parse("2021-02-01T00:00:00Z")), new Field("k1", new BytesRef((CharSequence)"a"), (IndexableFieldType)KeywordFieldMapper.Defaults.FIELD_TYPE), new Field("k2", new BytesRef((CharSequence)"a"), (IndexableFieldType)KeywordFieldMapper.Defaults.FIELD_TYPE), new SortedNumericDocValuesField("n", 3L)));
            iw.addDocument(List.of(new SortedNumericDocValuesField(AGGREGABLE_DATE, dft.parse("2021-03-01T00:00:00Z")), new Field("k1", new BytesRef((CharSequence)"a"), (IndexableFieldType)KeywordFieldMapper.Defaults.FIELD_TYPE), new Field("k2", new BytesRef((CharSequence)"b"), (IndexableFieldType)KeywordFieldMapper.Defaults.FIELD_TYPE), new SortedNumericDocValuesField("n", 4L)));
            iw.addDocument(List.of(new SortedNumericDocValuesField(AGGREGABLE_DATE, dft.parse("2020-02-01T00:00:00Z")), new Field("k1", new BytesRef((CharSequence)"b"), (IndexableFieldType)KeywordFieldMapper.Defaults.FIELD_TYPE), new Field("k2", new BytesRef((CharSequence)"b"), (IndexableFieldType)KeywordFieldMapper.Defaults.FIELD_TYPE), new SortedNumericDocValuesField("n", 5L)));
        };
        this.asSubAggTestCase(builder, (CheckedBiConsumer<RandomIndexWriter, DateFieldMapper.DateFieldType, IOException>)buildIndex, verify);
    }

    protected final <R extends InternalAggregation> void asSubAggTestCase(AggregationBuilder builder, CheckedBiConsumer<RandomIndexWriter, DateFieldMapper.DateFieldType, IOException> buildIndex, Consumer<R> verify) throws IOException {
        KeywordFieldMapper.KeywordFieldType k1ft = new KeywordFieldMapper.KeywordFieldType("k1");
        KeywordFieldMapper.KeywordFieldType k2ft = new KeywordFieldMapper.KeywordFieldType("k2");
        NumberFieldMapper.NumberFieldType nft = new NumberFieldMapper.NumberFieldType("n", NumberFieldMapper.NumberType.LONG);
        DateFieldMapper.DateFieldType dft = this.aggregableDateFieldType(false, DateHistogramAggregatorTestCase.randomBoolean());
        this.testCase((CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> buildIndex.accept(iw, (Object)dft)), verify, new AggregatorTestCase.AggTestConfig(builder, new MappedFieldType[]{k1ft, k2ft, nft, dft}));
    }

    protected final DateFieldMapper.DateFieldType aggregableDateFieldType(boolean useNanosecondResolution, boolean isSearchable) {
        return this.aggregableDateFieldType(useNanosecondResolution, isSearchable, DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER);
    }

    protected final DateFieldMapper.DateFieldType aggregableDateFieldType(boolean useNanosecondResolution, boolean isSearchable, DateFormatter formatter) {
        return new DateFieldMapper.DateFieldType(AGGREGABLE_DATE, IndexType.points((boolean)isSearchable, (boolean)true), DateHistogramAggregatorTestCase.randomBoolean(), true, formatter, useNanosecondResolution ? DateFieldMapper.Resolution.NANOSECONDS : DateFieldMapper.Resolution.MILLISECONDS, null, null, Collections.emptyMap());
    }
}

