/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.chunking;

import com.ibm.icu.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.core.inference.chunking.Chunker;
import org.elasticsearch.xpack.core.inference.chunking.ChunkerBuilder;
import org.elasticsearch.xpack.core.inference.chunking.ChunkerUtils;
import org.elasticsearch.xpack.core.inference.chunking.ChunkingSettingsBuilder;
import org.elasticsearch.xpack.core.inference.results.RankedDocsResults;

public class RerankRequestChunker {
    private final List<String> inputs;
    private final List<RerankChunks> rerankChunks;

    public RerankRequestChunker(String query, List<String> inputs, Integer maxChunksPerDoc) {
        this.inputs = inputs;
        this.rerankChunks = this.chunk(inputs, this.buildChunkingSettingsForElasticRerank(query), maxChunksPerDoc);
    }

    private List<RerankChunks> chunk(List<String> inputs, ChunkingSettings chunkingSettings, Integer maxChunksPerDoc) {
        Chunker chunker = ChunkerBuilder.fromChunkingStrategy(chunkingSettings.getChunkingStrategy());
        ArrayList<RerankChunks> chunks = new ArrayList<RerankChunks>();
        for (int i = 0; i < inputs.size(); ++i) {
            List<Chunker.ChunkOffset> chunksForInput = chunker.chunk(inputs.get(i), chunkingSettings);
            if (maxChunksPerDoc != null && chunksForInput.size() > maxChunksPerDoc) {
                chunksForInput = chunksForInput.subList(0, maxChunksPerDoc);
            }
            for (Chunker.ChunkOffset chunk : chunksForInput) {
                chunks.add(new RerankChunks(i, inputs.get(i).substring(chunk.start(), chunk.end())));
            }
        }
        return chunks;
    }

    public List<String> getChunkedInputs() {
        ArrayList<String> chunkedInputs = new ArrayList<String>();
        for (RerankChunks chunk : this.rerankChunks) {
            chunkedInputs.add(chunk.chunkString());
        }
        return chunkedInputs;
    }

    public ActionListener<InferenceServiceResults> parseChunkedRerankResultsListener(ActionListener<InferenceServiceResults> listener, boolean returnDocuments) {
        return ActionListener.wrap(results -> {
            if (results instanceof RankedDocsResults) {
                RankedDocsResults rankedDocsResults = (RankedDocsResults)results;
                listener.onResponse((Object)this.parseRankedDocResultsForChunks(rankedDocsResults, returnDocuments));
            } else {
                listener.onFailure((Exception)new IllegalArgumentException("Expected RankedDocsResults but got: " + String.valueOf(results.getClass())));
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private RankedDocsResults parseRankedDocResultsForChunks(RankedDocsResults rankedDocsResults, boolean returnDocuments) {
        ArrayList<RankedDocsResults.RankedDoc> topRankedDocs = new ArrayList<RankedDocsResults.RankedDoc>();
        HashSet<Integer> docIndicesSeen = new HashSet<Integer>();
        ArrayList<RankedDocsResults.RankedDoc> rankedDocs = new ArrayList<RankedDocsResults.RankedDoc>(rankedDocsResults.getRankedDocs());
        rankedDocs.sort((r1, r2) -> Float.compare(r2.relevanceScore(), r1.relevanceScore()));
        for (RankedDocsResults.RankedDoc rankedDoc : rankedDocs) {
            int chunkIndex = rankedDoc.index();
            int docIndex = this.rerankChunks.get(chunkIndex).docIndex();
            if (docIndicesSeen.contains(docIndex)) continue;
            RankedDocsResults.RankedDoc updatedRankedDoc = new RankedDocsResults.RankedDoc(docIndex, rankedDoc.relevanceScore(), returnDocuments ? this.inputs.get(docIndex) : null);
            topRankedDocs.add(updatedRankedDoc);
            docIndicesSeen.add(docIndex);
        }
        return new RankedDocsResults(topRankedDocs);
    }

    private ChunkingSettings buildChunkingSettingsForElasticRerank(String query) {
        BreakIterator wordIterator = BreakIterator.getWordInstance();
        wordIterator.setText(query);
        int queryWordCount = ChunkerUtils.countWords(0, query.length(), wordIterator);
        return ChunkingSettingsBuilder.buildChunkingSettingsForElasticRerank(queryWordCount);
    }

    public record RerankChunks(int docIndex, String chunkString) {
    }
}

