/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.aggregation.table.RowInTableLookup;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AbstractPageMappingToIteratorOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

public class RowInTableLookupOperator
extends AbstractPageMappingToIteratorOperator {
    private final List<String> keys;
    private final RowInTableLookup lookup;
    private final int[] blockMapping;

    public RowInTableLookupOperator(BlockFactory blockFactory, Key[] keys, int[] blockMapping) {
        if (keys.length < 1) {
            throw new IllegalArgumentException("expected [keys] to be non-empty");
        }
        this.blockMapping = blockMapping;
        this.keys = new ArrayList<String>(keys.length);
        Block[] blocks = new Block[keys.length];
        for (int k = 0; k < keys.length; ++k) {
            this.keys.add(keys[k].name);
            blocks[k] = keys[k].block;
        }
        this.lookup = RowInTableLookup.build(blockFactory, blocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ReleasableIterator<Page> receive(Page page) {
        Page mapped = page.projectBlocks(this.blockMapping);
        try {
            ReleasableIterator<Page> releasableIterator = RowInTableLookupOperator.appendBlocks(page, this.lookup.lookup(mapped, BlockFactory.DEFAULT_MAX_BLOCK_PRIMITIVE_ARRAY_SIZE));
            return releasableIterator;
        }
        finally {
            mapped.releaseBlocks();
        }
    }

    @Override
    public String toString() {
        return "RowInTableLookup[" + String.valueOf(this.lookup) + ", keys=" + String.valueOf(this.keys) + ", mapping=" + Arrays.toString(this.blockMapping) + "]";
    }

    @Override
    public void close() {
        Releasables.close((Releasable[])new Releasable[]{() -> super.close(), this.lookup});
    }

    public record Key(String name, Block block) {
        @Override
        public String toString() {
            return "{name=" + this.name + ", type=" + String.valueOf((Object)this.block.elementType()) + ", positions=" + this.block.getPositionCount() + ", size=" + String.valueOf(ByteSizeValue.ofBytes((long)this.block.ramBytesUsed())) + "}";
        }
    }

    public record Factory(Key[] keys, int[] blockMapping) implements Operator.OperatorFactory
    {
        public Factory {
            if (keys.length < 1) {
                throw new IllegalArgumentException("expected [keys] to be non-empty");
            }
        }

        @Override
        public Operator get(DriverContext driverContext) {
            return new RowInTableLookupOperator(driverContext.blockFactory(), this.keys, this.blockMapping);
        }

        @Override
        public String describe() {
            return "RowInTableLookup[keys=" + Arrays.toString(this.keys) + ", mapping=" + Arrays.toString(this.blockMapping) + "]";
        }
    }
}

