/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import java.util.Optional;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.rest.RestRequest;

public class SearchParamsParser {
    public static final String MRT_SET_IN_CPS_WARN = "ccs_minimize_roundtrips always defaults to true in Cross Project Search context. Setting it explicitly has no effect irrespective of the value specified and is ignored. It will soon be deprecated and made unavailable for Cross project Search.";

    public static boolean parseCcsMinimizeRoundtrips(Optional<Boolean> crossProjectEnabled, RestRequest request) {
        return SearchParamsParser.parseCcsMinimizeRoundtrips(crossProjectEnabled, request, true);
    }

    public static boolean parseCcsMinimizeRoundtrips(Optional<Boolean> crossProjectEnabled, RestRequest request, boolean defaultValue) {
        if (crossProjectEnabled.orElse(false).booleanValue()) {
            if (request.hasParam("ccs_minimize_roundtrips")) {
                request.param("ccs_minimize_roundtrips");
                HeaderWarning.addWarning(MRT_SET_IN_CPS_WARN, new Object[0]);
                return true;
            }
            return true;
        }
        return request.paramAsBoolean("ccs_minimize_roundtrips", defaultValue);
    }
}

