/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.elasticsearch.common.lucene.FilterIndexCommit;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.engine.ElasticsearchIndexDeletionPolicy;
import org.elasticsearch.index.engine.SafeCommitInfo;
import org.elasticsearch.index.engine.SoftDeletesPolicy;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.translog.TranslogDeletionPolicy;

public class CombinedDeletionPolicy
extends ElasticsearchIndexDeletionPolicy {
    private final Logger logger;
    private final TranslogDeletionPolicy translogDeletionPolicy;
    private final SoftDeletesPolicy softDeletesPolicy;
    private final LongSupplier globalCheckpointSupplier;
    private final Map<IndexCommit, Integer> acquiredIndexCommits;
    private final Set<IndexCommit> internallyAcquiredIndexCommits;
    @Nullable
    private final ElasticsearchIndexDeletionPolicy.CommitsListener commitsListener;
    private volatile IndexCommit safeCommit;
    private volatile long maxSeqNoOfNextSafeCommit;
    private volatile IndexCommit lastCommit;
    private volatile SafeCommitInfo safeCommitInfo = SafeCommitInfo.EMPTY;

    CombinedDeletionPolicy(Logger logger, TranslogDeletionPolicy translogDeletionPolicy, SoftDeletesPolicy softDeletesPolicy, LongSupplier globalCheckpointSupplier, @Nullable ElasticsearchIndexDeletionPolicy.CommitsListener commitsListener) {
        this.logger = logger;
        this.translogDeletionPolicy = translogDeletionPolicy;
        this.softDeletesPolicy = softDeletesPolicy;
        this.globalCheckpointSupplier = globalCheckpointSupplier;
        this.commitsListener = commitsListener;
        this.acquiredIndexCommits = new HashMap<IndexCommit, Integer>();
        this.internallyAcquiredIndexCommits = new HashSet<IndexCommit>();
    }

    public void onInit(List<? extends IndexCommit> commits) throws IOException {
        assert (!commits.isEmpty()) : "index is opened, but we have no commits";
        this.onCommit(commits);
        if (this.safeCommit != commits.get(commits.size() - 1)) {
            throw new IllegalStateException("Engine is opened, but the last commit isn't safe. Global checkpoint [" + this.globalCheckpointSupplier.getAsLong() + "], seqNo is last commit [" + String.valueOf(SequenceNumbers.loadSeqNoInfoFromLuceneCommit(this.lastCommit.getUserData().entrySet())) + "], seqNos in safe commit [" + String.valueOf(SequenceNumbers.loadSeqNoInfoFromLuceneCommit(this.safeCommit.getUserData().entrySet())) + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCommit(List<? extends IndexCommit> commits) throws IOException {
        IndexCommit newCommit;
        IndexCommit previousLastCommit;
        assert (!Thread.holdsLock((Object)this)) : "should not block concurrent acquire or release";
        int keptPosition = CombinedDeletionPolicy.indexOfKeptCommits(commits, this.globalCheckpointSupplier.getAsLong());
        IndexCommit safeCommit = commits.get(keptPosition);
        SafeCommitInfo newSafeCommitInfo = this.getNewSafeCommitInfo(safeCommit);
        ArrayList<IndexCommit> deletedCommits = null;
        CombinedDeletionPolicy combinedDeletionPolicy = this;
        synchronized (combinedDeletionPolicy) {
            this.safeCommitInfo = newSafeCommitInfo;
            previousLastCommit = this.lastCommit;
            this.lastCommit = commits.get(commits.size() - 1);
            this.safeCommit = safeCommit;
            this.updateRetentionPolicy();
            this.maxSeqNoOfNextSafeCommit = keptPosition == commits.size() - 1 ? Long.MAX_VALUE : Long.parseLong((String)commits.get(keptPosition + 1).getUserData().get("max_seq_no"));
            newCommit = this.commitsListener != null && previousLastCommit != this.lastCommit ? this.acquireIndexCommit(false, true) : null;
            for (int i = 0; i < keptPosition; ++i) {
                IndexCommit commit = commits.get(i);
                if (this.acquiredIndexCommits.containsKey(commit)) continue;
                this.deleteCommit(commit);
                if (deletedCommits == null) {
                    deletedCommits = new ArrayList<IndexCommit>();
                }
                deletedCommits.add(commit);
            }
        }
        assert (this.assertSafeCommitUnchanged(safeCommit));
        if (this.commitsListener != null) {
            if (newCommit != null) {
                Set<String> additionalFiles = Lucene.additionalFileNames(previousLastCommit, newCommit);
                this.commitsListener.onNewAcquiredCommit(newCommit, additionalFiles);
            }
            if (deletedCommits != null) {
                for (IndexCommit deletedCommit : deletedCommits) {
                    this.commitsListener.onDeletedCommit(deletedCommit);
                }
            }
        }
    }

    private SafeCommitInfo getNewSafeCommitInfo(IndexCommit newSafeCommit) {
        long newSafeCommitLocalCheckpoint;
        SafeCommitInfo currentSafeCommitInfo = this.safeCommitInfo;
        try {
            newSafeCommitLocalCheckpoint = Long.parseLong((String)newSafeCommit.getUserData().get("local_checkpoint"));
        }
        catch (Exception ex) {
            this.logger.info("failed to get the local checkpoint from the safe commit; use the info from the previous safe commit", (Throwable)ex);
            return currentSafeCommitInfo;
        }
        if (currentSafeCommitInfo.localCheckpoint() == newSafeCommitLocalCheckpoint) {
            return currentSafeCommitInfo;
        }
        try {
            return new SafeCommitInfo(newSafeCommitLocalCheckpoint, this.getDocCountOfCommit(newSafeCommit));
        }
        catch (IOException ex) {
            this.logger.info("failed to get the total docs from the safe commit; use the total docs from the previous safe commit", (Throwable)ex);
            return new SafeCommitInfo(newSafeCommitLocalCheckpoint, currentSafeCommitInfo.docCount());
        }
    }

    private boolean assertSafeCommitUnchanged(IndexCommit safeCommit) {
        IndexCommit newSafeCommit = this.safeCommit;
        assert (safeCommit == newSafeCommit) : "onCommit called concurrently? " + safeCommit.getGeneration() + " vs " + newSafeCommit.getGeneration();
        return true;
    }

    private void deleteCommit(IndexCommit commit) throws IOException {
        assert (!commit.isDeleted()) : "Index commit [" + CombinedDeletionPolicy.commitDescription(commit) + "] is deleted twice";
        this.logger.debug("Delete index commit [{}]", (Object)CombinedDeletionPolicy.commitDescription(commit));
        commit.delete();
    }

    private void updateRetentionPolicy() throws IOException {
        assert (Thread.holdsLock((Object)this));
        this.logger.debug("Safe commit [{}], last commit [{}]", (Object)CombinedDeletionPolicy.commitDescription(this.safeCommit), (Object)CombinedDeletionPolicy.commitDescription(this.lastCommit));
        assert (!this.safeCommit.isDeleted()) : "The safe commit must not be deleted";
        assert (!this.lastCommit.isDeleted()) : "The last commit must not be deleted";
        long localCheckpointOfSafeCommit = Long.parseLong((String)this.safeCommit.getUserData().get("local_checkpoint"));
        this.softDeletesPolicy.setLocalCheckpointOfSafeCommit(localCheckpointOfSafeCommit);
        this.translogDeletionPolicy.setLocalCheckpointOfSafeCommit(localCheckpointOfSafeCommit);
    }

    protected int getDocCountOfCommit(IndexCommit indexCommit) throws IOException {
        return SegmentInfos.readCommit((Directory)indexCommit.getDirectory(), (String)indexCommit.getSegmentsFileName()).totalMaxDoc();
    }

    @Override
    public SafeCommitInfo getSafeCommitInfo() {
        return this.safeCommitInfo;
    }

    @Override
    public synchronized IndexCommit acquireIndexCommit(boolean acquiringSafeCommit) {
        return this.acquireIndexCommit(acquiringSafeCommit, false);
    }

    private synchronized IndexCommit acquireIndexCommit(boolean acquiringSafeCommit, boolean acquiredInternally) {
        assert (this.safeCommit != null) : "Safe commit is not initialized yet";
        assert (this.lastCommit != null) : "Last commit is not initialized yet";
        IndexCommit snapshotting = acquiringSafeCommit ? this.safeCommit : this.lastCommit;
        this.acquiredIndexCommits.merge(snapshotting, 1, Integer::sum);
        assert (!acquiredInternally || this.internallyAcquiredIndexCommits.add(snapshotting)) : "commit [" + String.valueOf(snapshotting) + "] already added";
        return this.wrapCommit(snapshotting, acquiredInternally);
    }

    protected IndexCommit wrapCommit(IndexCommit indexCommit) {
        return this.wrapCommit(indexCommit, false);
    }

    protected IndexCommit wrapCommit(IndexCommit indexCommit, boolean acquiredInternally) {
        return new SnapshotIndexCommit(indexCommit, acquiredInternally);
    }

    @Override
    public synchronized boolean releaseIndexCommit(IndexCommit acquiredCommit) {
        SnapshotIndexCommit snapshotIndexCommit = (SnapshotIndexCommit)acquiredCommit;
        IndexCommit releasingCommit = snapshotIndexCommit.getIndexCommit();
        assert (this.acquiredIndexCommits.containsKey(releasingCommit)) : "Release non-acquired commit;acquired commits [" + String.valueOf(this.acquiredIndexCommits) + "], releasing commit [" + String.valueOf(releasingCommit) + "]";
        Integer refCount = this.acquiredIndexCommits.compute(releasingCommit, (key, count) -> {
            if (count == 1) {
                return null;
            }
            return count - 1;
        });
        assert (!snapshotIndexCommit.acquiredInternally || this.internallyAcquiredIndexCommits.remove(releasingCommit)) : "Trying to release a commit [" + String.valueOf(releasingCommit) + "] that hasn't been previously acquired internally";
        assert (refCount == null || refCount > 0) : "Number of references for acquired commit can not be negative [" + refCount + "]";
        return refCount == null && !releasingCommit.equals((Object)this.safeCommit) && !releasingCommit.equals((Object)this.lastCommit);
    }

    public static IndexCommit findSafeCommitPoint(List<IndexCommit> commits, long globalCheckpoint) throws IOException {
        if (commits.isEmpty()) {
            throw new IllegalArgumentException("Commit list must not empty");
        }
        int keptPosition = CombinedDeletionPolicy.indexOfKeptCommits(commits, globalCheckpoint);
        return commits.get(keptPosition);
    }

    private static int indexOfKeptCommits(List<? extends IndexCommit> commits, long globalCheckpoint) throws IOException {
        String expectedTranslogUUID = (String)commits.get(commits.size() - 1).getUserData().get("translog_uuid");
        for (int i = commits.size() - 1; i >= 0; --i) {
            Map commitUserData = commits.get(i).getUserData();
            if (!expectedTranslogUUID.equals(commitUserData.get("translog_uuid"))) {
                return i + 1;
            }
            long maxSeqNoFromCommit = Long.parseLong((String)commitUserData.get("max_seq_no"));
            if (maxSeqNoFromCommit > globalCheckpoint) continue;
            return i;
        }
        return 0;
    }

    @Override
    public synchronized boolean hasAcquiredIndexCommitsForTesting() {
        for (Map.Entry<IndexCommit, Integer> e : this.acquiredIndexCommits.entrySet()) {
            if (this.internallyAcquiredIndexCommits.contains(e.getKey()) && e.getValue() <= 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasUnreferencedCommits() {
        return this.maxSeqNoOfNextSafeCommit <= this.globalCheckpointSupplier.getAsLong();
    }

    public static String commitDescription(IndexCommit commit) throws IOException {
        return String.format(Locale.ROOT, "CommitPoint{segment[%s], userData[%s]}", commit.getSegmentsFileName(), commit.getUserData());
    }

    private static class SnapshotIndexCommit
    extends FilterIndexCommit {
        private final boolean acquiredInternally;

        SnapshotIndexCommit(IndexCommit delegate, boolean acquiredInternally) {
            super(delegate);
            this.acquiredInternally = acquiredInternally;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("A snapshot commit does not support deletion");
        }
    }
}

