/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.uaparser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.logstash.uaparser.Client;
import org.logstash.uaparser.Parser;

public final class CachingParser
extends Parser {
    private Parser parser;
    private Map<String, Client> cacheClient;

    public CachingParser(int cacheSize) {
        this(new Parser(), cacheSize);
    }

    public CachingParser(String yamlPath, int cacheSize) throws IOException {
        this(new Parser(new ByteArrayInputStream(Files.readAllBytes(Paths.get(yamlPath, new String[0])))), cacheSize);
    }

    CachingParser(String regexYaml) {
        this(new Parser(new ByteArrayInputStream(regexYaml.getBytes(StandardCharsets.UTF_8))));
    }

    CachingParser() {
        this(new Parser());
    }

    private CachingParser(Parser parser) {
        this(parser, 100000);
    }

    private CachingParser(Parser parser, int cacheSize) {
        this.parser = parser;
        this.cacheClient = Collections.synchronizedMap(new LRUMap(cacheSize));
    }

    @Override
    public Client parse(String agentString) {
        if (agentString == null) {
            return null;
        }
        Client client = this.cacheClient.get(agentString);
        if (client != null) {
            return client;
        }
        Client parsed = this.parser.parse(agentString);
        this.cacheClient.put(agentString, parsed);
        return parsed;
    }
}

