"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useArtifactRestrictedPolicyAssignments = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _use_bulk_fetch_fleet_integration_policies = require("../policy/use_bulk_fetch_fleet_integration_policies");
var _artifacts = require("../../../../common/endpoint/service/artifacts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Given an artifact item, hook will calculate if any of the policies assigned to it
 * are restricted (not accessible by the current user) in the active space.
 *
 * NOTE: this hook's logic is executed at most once per artifact
 *
 * @param item
 */
const useArtifactRestrictedPolicyAssignments = item => {
  var _item$item_id;
  const [{
    itemId,
    policies
  }, setOriginalItem] = (0, _react.useState)({
    itemId: (_item$item_id = item.item_id) !== null && _item$item_id !== void 0 ? _item$item_id : '',
    policies: (0, _artifacts.getPolicyIdsFromArtifact)(item)
  });
  const {
    data,
    isFetching
  } = (0, _use_bulk_fetch_fleet_integration_policies.useBulkFetchFleetIntegrationPolicies)({
    ids: policies
  }, {
    enabled: policies.length > 0
  });
  const restrictedPolicyIds = (0, _react.useMemo)(() => {
    if (!(data !== null && data !== void 0 && data.items)) {
      return [];
    }
    const policiesFoundById = (0, _lodash.keyBy)(data.items, 'id');
    return policies.filter(id => !policiesFoundById[id]);
  }, [data === null || data === void 0 ? void 0 : data.items, policies]);
  (0, _react.useEffect)(() => {
    if (item.item_id !== itemId) {
      var _item$item_id2;
      setOriginalItem({
        itemId: (_item$item_id2 = item.item_id) !== null && _item$item_id2 !== void 0 ? _item$item_id2 : '',
        policies: (0, _artifacts.getPolicyIdsFromArtifact)(item)
      });
    }
  }, [item, itemId]);
  return (0, _react.useMemo)(() => {
    return {
      isLoading: policies.length > 0 ? isFetching : false,
      policyIds: restrictedPolicyIds
    };
  }, [isFetching, policies.length, restrictedPolicyIds]);
};
exports.useArtifactRestrictedPolicyAssignments = useArtifactRestrictedPolicyAssignments;