"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextareaInputArgument = exports.TEXTAREA_PLACEHOLDER_TEXT = exports.OPEN_INPUT = exports.NO_INPUT_ENTERED_MESSAGE = exports.HELP_NOT_AVAILABLE_TOOLTIP = exports.HELP_ICON_LABEL = exports.CLOSE_POPUP_BUTTON_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console_argument_selectors/textarea_input_argument/textarea_input_argument.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable @typescript-eslint/no-explicit-any */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OPEN_INPUT = exports.OPEN_INPUT = _i18n.i18n.translate('xpack.securitySolution.consoleArgumentSelectors.textAreaInputArgument.openInputButton', {
  defaultMessage: 'Edit values'
});
const TEXTAREA_PLACEHOLDER_TEXT = exports.TEXTAREA_PLACEHOLDER_TEXT = _i18n.i18n.translate('xpack.securitySolution.consoleArgumentSelectors.textAreaInputArgument.textareaPlaceholderText', {
  defaultMessage: 'Enter data here'
});
const NO_INPUT_ENTERED_MESSAGE = exports.NO_INPUT_ENTERED_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.consoleArgumentSelectors.textAreaInputArgument.noInputEnteredMessage', {
  defaultMessage: 'Click to enter values'
});
const HELP_ICON_LABEL = exports.HELP_ICON_LABEL = _i18n.i18n.translate('xpack.securitySolution.consoleArgumentSelectors.textAreaInputArgument.helpIconLabel', {
  defaultMessage: 'Toggle instructions'
});
const CLOSE_POPUP_BUTTON_LABEL = exports.CLOSE_POPUP_BUTTON_LABEL = _i18n.i18n.translate('xpack.securitySolution.consoleArgumentSelectors.textAreaInputArgument.closePopupButtonLabel', {
  defaultMessage: 'Apply'
});
const HELP_NOT_AVAILABLE_TOOLTIP = exports.HELP_NOT_AVAILABLE_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.consoleArgumentSelectors.textAreaInputArgument.helpNotAvailable', {
  defaultMessage: 'No instructions available'
});

/**
 * Console argument component that displays a popup textarea for user to enter free-form data.
 */
const TextareaInputArgument = exports.TextareaInputArgument = /*#__PURE__*/(0, _react.memo)(({
  value: propsValue,
  valueText = '',
  store: state = {
    isPopoverOpen: true
  },
  argName,
  argIndex,
  onChange,
  command,
  openLabel = OPEN_INPUT,
  noInputEnteredMessage = NO_INPUT_ENTERED_MESSAGE,
  textareaPlaceholderLabel = TEXTAREA_PLACEHOLDER_TEXT,
  helpIconLabel = HELP_ICON_LABEL,
  helpNotAvailableTooltip = HELP_NOT_AVAILABLE_TOOLTIP,
  closePopupButtonLabel = CLOSE_POPUP_BUTTON_LABEL,
  width,
  textareaLabel,
  helpContent,
  showHelpIcon = true,
  'data-test-subj': dataTestSubj
}) => {
  const value = propsValue !== null && propsValue !== void 0 ? propsValue : '';
  const testId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : `textareaInputArgument-${command.commandDefinition.name}-${argName}-${argIndex}`);
  const isMounted = (0, _securitysolutionHookUtils.useIsMounted)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [showHelpContent, setShowHelpContent] = (0, _react.useState)(false);
  const textAreaHtmlId = (0, _react.useMemo)(() => {
    return (0, _eui.htmlIdGenerator)('textarea')();
  }, []);
  const textareaContainerCss = (0, _react.useMemo)(() => {
    return (0, _react2.css)`
        --height: 15rem;

        .textarea-container {
          textarea {
            min-width: 275px;
            width: ${width !== null && width !== void 0 ? width : '20vw'};
            height: var(--height);
            box-shadow: none;
            border: ${euiTheme.border.thin};
          }
        }

        .help-container {
          width: 25rem;
          max-width: 50%;
          word-break: break-word;
          white-space: pre-wrap;
          height: var(--height);
        }
      `;
  }, [euiTheme.border.thin, width]);

  // Because the console supports multiple instances of the same argument, we need to ensure that
  // if the command was defined to now allow multiples, that we only render the first one.
  const shouldRender = (0, _react.useMemo)(() => {
    var _command$commandDefin;
    const argDefinition = (_command$commandDefin = command.commandDefinition.args) === null || _command$commandDefin === void 0 ? void 0 : _command$commandDefin[argName];
    return (argDefinition === null || argDefinition === void 0 ? void 0 : argDefinition.allowMultiples) || argIndex === 0;
  }, [argIndex, argName, command.commandDefinition.args]);
  const handleClosePopover = (0, _react.useCallback)(() => {
    onChange({
      value,
      valueText: value.replace(/\r?\n/g, ' ').trim(),
      store: {
        ...state,
        isPopoverOpen: false
      }
    });
  }, [onChange, state, value]);
  const handleOpenPopover = (0, _react.useCallback)(() => {
    onChange({
      value,
      valueText,
      store: {
        ...state,
        isPopoverOpen: !state.isPopoverOpen
      }
    });
  }, [onChange, state, value, valueText]);
  const handleTextAreaOnChange = (0, _react.useCallback)(ev => {
    const newValue = ev.target.value || '';
    onChange({
      valueText,
      // We leave the display text as is until the popup is closed - to avoid UI jankiness
      value: newValue,
      store: state
    });
  }, [onChange, state, valueText]);
  const handleHelpOnClick = (0, _react.useCallback)(() => {
    setShowHelpContent(prev => !prev);
  }, []);
  (0, _react.useEffect)(() => {
    // If the user picked a different script, after having already opened the help area, make
    // sure we reset the `showHelpContent` if the new script has no help content.
    if (isMounted() && showHelpContent && !helpContent) {
      setShowHelpContent(false);
    }
  }, [helpContent, isMounted, showHelpContent]);
  (0, _react.useEffect)(() => {
    // If the argument selector should not be rendered, then at least set the `value` to a string
    // so that the normal console argument validations can be invoked if the user still ENTERs
    // the command
    if (isMounted() && !shouldRender && propsValue !== '') {
      onChange({
        value: '',
        valueText: '',
        store: state
      });
    }
  }, [onChange, shouldRender, state, propsValue, isMounted]);
  return shouldRender ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: state.isPopoverOpen,
    anchorPosition: "upCenter",
    "data-test-subj": testId(),
    closePopover: handleClosePopover,
    initialFocus: `textarea.${textAreaHtmlId}`,
    panelProps: {
      'data-test-subj': testId('popoverPanel')
    },
    panelPaddingSize: "s",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      alignItems: "center",
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: "eui-textTruncate",
      onClick: handleOpenPopover,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "eui-textTruncate",
      "data-test-subj": testId('selectionDisplay'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 15
      }
    }, valueText || /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 19
      }
    }, noInputEnteredMessage))), showHelpIcon && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 256,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "pencil",
      size: "xs",
      onClick: handleOpenPopover,
      title: openLabel,
      "aria-label": openLabel,
      "data-test-subj": testId('openInputButton'),
      css: (0, _react2.css)`
                    inline-size: auto;
                    block-size: auto;
                  `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 257,
        columnNumber: 17
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 7
    }
  }, state.isPopoverOpen && /*#__PURE__*/_react.default.createElement("div", {
    css: textareaContainerCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasShadow: false,
    hasBorder: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    "data-test-subj": testId('title'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 21
    }
  }, textareaLabel !== null && textareaLabel !== void 0 ? textareaLabel : argName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: helpContent ? helpIconLabel : helpNotAvailableTooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "help",
    size: "xs",
    onClick: handleHelpOnClick,
    isSelected: showHelpContent,
    title: helpIconLabel,
    "aria-label": helpIconLabel,
    disabled: !helpContent,
    "data-test-subj": testId('helpButton'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 21
    }
  }))))), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: false,
    alignItems: "flexStart",
    justifyContent: "spaceEvenly",
    gutterSize: "xs",
    className: "eui-fullHeight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "textarea-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    value: value,
    placeholder: textareaPlaceholderLabel,
    onChange: handleTextAreaOnChange,
    className: textAreaHtmlId,
    resize: "none",
    fullWidth: true,
    "data-test-subj": testId('textarea'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 19
    }
  })), showHelpContent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "help-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    hasBorder: true,
    className: "eui-fullHeight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: "eui-scrollBar eui-yScroll",
    "data-test-subj": testId('helpContent'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 23
    }
  }, helpContent))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasShadow: false,
    hasBorder: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 340,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    justifyContent: "flexEnd",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: handleClosePopover,
    "data-test-subj": testId('closeButton'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 19
    }
  }, closePopupButtonLabel)))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    "data-test-subj": testId('noMultipleArgs'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 9
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.consoleArgumentSelectors.textAreaInputArgument.noMultipleArgs",
    defaultMessage: "Argument is only supported once per command",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 9
    }
  }));
});
TextareaInputArgument.displayName = 'TextareaInputArgument';