"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrowdstrikeScriptInputParams = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _script_help_content = require("./shared/script_help_content");
var _textarea_input_argument = require("../textarea_input_argument");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console_argument_selectors/script_input_params_selector/crowdstrike_script_input_params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CrowdstrikeScriptInputParams = exports.CrowdstrikeScriptInputParams = /*#__PURE__*/(0, _react.memo)(props => {
  var _props$command$args, _props$command$argSta6;
  const args = (_props$command$args = props.command.args) === null || _props$command$args === void 0 ? void 0 : _props$command$args.args;
  const scriptName = (0, _react.useMemo)(() => {
    if (args.HostPath) {
      return args.HostPath[0];
    }
    if (args.CloudFile) {
      return args.CloudFile[0];
    }
    return '';
  }, [args.CloudFile, args.HostPath]);
  const scriptHelp = (0, _react.useMemo)(() => {
    if (args.CloudFile) {
      var _props$command$argSta, _props$command$argSta2, _props$command$argSta3, _props$command$argSta4, _props$command$argSta5;
      return (_props$command$argSta = props.command.argState) === null || _props$command$argSta === void 0 ? void 0 : (_props$command$argSta2 = _props$command$argSta.CloudFile) === null || _props$command$argSta2 === void 0 ? void 0 : (_props$command$argSta3 = _props$command$argSta2.at(0)) === null || _props$command$argSta3 === void 0 ? void 0 : (_props$command$argSta4 = _props$command$argSta3.store) === null || _props$command$argSta4 === void 0 ? void 0 : (_props$command$argSta5 = _props$command$argSta4.selectedOption) === null || _props$command$argSta5 === void 0 ? void 0 : _props$command$argSta5.description;
    }
    return '';
  }, [args.CloudFile, (_props$command$argSta6 = props.command.argState) === null || _props$command$argSta6 === void 0 ? void 0 : _props$command$argSta6.CloudFile]);
  const customizedProps = (0, _react.useMemo)(() => {
    return {
      helpContent: scriptHelp ? /*#__PURE__*/_react.default.createElement(_script_help_content.ScriptHelpContent, {
        description: scriptHelp,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 33
        }
      }) : undefined,
      textareaLabel: _i18n.i18n.translate('xpack.securitySolution.crowdstrikeScriptInputParams.textareaLabel', {
        defaultMessage: 'Script command line arguments'
      }),
      textareaPlaceholderLabel: _i18n.i18n.translate('xpack.securitySolution.crowdstrikeScriptInputParams.textareaPlaceholderLabel', {
        defaultMessage: 'Enter command line arguments for {scriptName}',
        values: {
          scriptName: scriptName || _i18n.i18n.translate('xpack.securitySolution.crowdstrikeScriptInputParams.script', {
            defaultMessage: 'script'
          })
        }
      })
    };
  }, [scriptHelp, scriptName]);
  return /*#__PURE__*/_react.default.createElement(_textarea_input_argument.TextareaInputArgument, (0, _extends2.default)({}, props, customizedProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 10
    }
  }));
});
CrowdstrikeScriptInputParams.displayName = 'CrowdstrikeScriptInputParams';