"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWithInputTextEntered = void 0;
var _react = require("react");
var _console_state = require("../../components/console_state/console_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useWithInputTextEntered = () => {
  const {
    leftOfCursorText,
    rightOfCursorText,
    parsedInput,
    enteredCommand
  } = (0, _console_state.useConsoleStore)().state.input;
  return (0, _react.useMemo)(() => {
    return {
      leftOfCursorText,
      rightOfCursorText,
      parsedInput,
      enteredCommand,
      fullTextEntered: leftOfCursorText + rightOfCursorText
    };
  }, [enteredCommand, leftOfCursorText, parsedInput, rightOfCursorText]);
};
exports.useWithInputTextEntered = useWithInputTextEntered;