"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWithCommandArgumentState = void 0;
var _react = require("react");
var _console_state = require("../../components/console_state/console_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the Command argument state for a given argument name. Should be used ONLY when a
 * command has been entered that matches a `CommandDefinition`
 * @param argName
 * @param instance
 */
const useWithCommandArgumentState = (argName, instance) => {
  const enteredCommand = (0, _console_state.useConsoleStore)().state.input.enteredCommand;
  return (0, _react.useMemo)(() => {
    var _enteredCommand$argSt;
    const argInstanceState = enteredCommand === null || enteredCommand === void 0 ? void 0 : (_enteredCommand$argSt = enteredCommand.argState[argName]) === null || _enteredCommand$argSt === void 0 ? void 0 : _enteredCommand$argSt.at(instance);
    return argInstanceState !== null && argInstanceState !== void 0 ? argInstanceState : {
      value: undefined,
      valueText: ''
    };
  }, [argName, enteredCommand, instance]);
};
exports.useWithCommandArgumentState = useWithCommandArgumentState;