"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executionTranslations = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _console_code_block = require("../../console_code_block");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/console_state/state_update_handlers/translations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const executionTranslations = exports.executionTranslations = Object.freeze({
  mustHaveValue: argName => {
    return _i18n.i18n.translate('xpack.securitySolution.console.commandValidation.mustHaveValue', {
      defaultMessage: 'Argument --{argName} must have a value',
      values: {
        argName
      }
    });
  },
  mustBeNumber: argName => {
    return _i18n.i18n.translate('xpack.securitySolution.console.commandValidation.mustBeNumber', {
      defaultMessage: 'Argument --{argName} value must be a number',
      values: {
        argName
      }
    });
  },
  mustBeGreaterThanZero: argName => {
    return _i18n.i18n.translate('xpack.securitySolution.console.commandValidation.mustBeGreaterThanZero', {
      defaultMessage: 'Argument --{argName} value must be greater than zero',
      values: {
        argName
      }
    });
  },
  NO_ARGUMENTS_SUPPORTED: _i18n.i18n.translate('xpack.securitySolution.console.commandValidation.noArgumentsSupported', {
    defaultMessage: 'Command does not support any arguments'
  }),
  missingRequiredArg: argName => {
    return _i18n.i18n.translate('xpack.securitySolution.console.commandValidation.missingRequiredArg', {
      defaultMessage: 'Missing required argument: --{argName}',
      values: {
        argName
      }
    });
  },
  unsupportedArg: argName => {
    return _i18n.i18n.translate('xpack.securitySolution.console.commandValidation.unsupportedArg', {
      defaultMessage: 'Unsupported argument: --{argName}',
      values: {
        argName
      }
    });
  },
  noMultiplesAllowed: argName => {
    return _i18n.i18n.translate('xpack.securitySolution.console.commandValidation.argSupportedOnlyOnce', {
      defaultMessage: 'Argument can only be used once: --{argName}',
      values: {
        argName
      }
    });
  },
  argValueValidatorError: (argName, error) => {
    return _i18n.i18n.translate('xpack.securitySolution.console.commandValidation.invalidArgValue', {
      defaultMessage: 'Invalid argument value: --{argName}. {error}',
      values: {
        argName,
        error
      }
    });
  },
  missingArguments: missingArgs => {
    return _i18n.i18n.translate('xpack.securitySolution.console.commandValidation.mustHaveArgs', {
      defaultMessage: 'Missing required arguments: {missingArgs}',
      values: {
        missingArgs
      }
    });
  },
  MUST_HAVE_AT_LEAST_ONE_ARG: _i18n.i18n.translate('xpack.securitySolution.console.commandValidation.oneArgIsRequired', {
    defaultMessage: 'At least one argument must be used'
  }),
  onlyOneFromExclusiveOr: argNames => {
    return /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.console.commandValidation.exclusiveOr",
      defaultMessage: "This command supports only one of the following arguments: {argNames}",
      values: {
        argNames: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
          bold: true,
          inline: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 98,
            columnNumber: 15
          }
        }, argNames)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 9
      }
    }));
  },
  unknownArgument: (count, commandName, unknownArgs) => {
    return /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.console.commandValidation.unknownArgument",
      defaultMessage: "The following {command} {countOfInvalidArgs, plural, =1 {argument is} other {arguments are}} not supported by this command: {unknownArgs}",
      values: {
        countOfInvalidArgs: count,
        command: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
          bold: true,
          inline: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 117,
            columnNumber: 15
          }
        }, commandName),
        unknownArgs: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
          bold: true,
          inline: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 122,
            columnNumber: 15
          }
        }, unknownArgs)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }));
  }
});