"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommandUsage = exports.CommandInputUsageExample = exports.CommandInputUsage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_input_command = require("../hooks/state_selectors/use_input_command");
var _console_code_block = require("./console_code_block");
var _parsed_command_input = require("../service/parsed_command_input");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _use_data_test_subj = require("../hooks/state_selectors/use_data_test_subj");
var _unsupported_message_callout = require("./unsupported_message_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/command_usage.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const additionalProps = {
  className: 'euiTruncateText'
};
const CommandInputUsageExample = exports.CommandInputUsageExample = /*#__PURE__*/(0, _react.memo)(({
  commandDef
}) => {
  const inputCommand = (0, _use_input_command.useInputCommand)();
  const helpExample = (0, _react.useMemo)(() => {
    if (commandDef.helpExample) {
      return commandDef.helpExample;
    }
    return typeof commandDef.exampleUsage === 'function' ? commandDef.exampleUsage(inputCommand) : commandDef.exampleUsage;
  }, [commandDef, inputCommand]);
  return helpExample && /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    columnWidths: [1, 4],
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.securitySolution.console.commandUsage.exampleUsage', {
        defaultMessage: 'Example'
      })),
      description: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 26
        }
      }, helpExample)
    }],
    descriptionProps: additionalProps,
    titleProps: additionalProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  });
});
CommandInputUsageExample.displayName = 'CommandInputUsageExample';
const CommandInputUsage = exports.CommandInputUsage = /*#__PURE__*/(0, _react.memo)(({
  commandDef,
  withHelpExample = true
}) => {
  const usageHelp = (0, _react.useMemo)(() => {
    if (commandDef.helpUsage) {
      return /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 16
        }
      }, commandDef.helpUsage);
    }
    const commandArgs = (0, _parsed_command_input.getArgumentsForCommand)(commandDef);
    if (commandArgs.length === 0) {
      return /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 16
        }
      }, commandDef.name);
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, commandArgs.map((usage, index) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: `helpUsage-${index}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 15
        }
      }, index > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 31
        }
      }), /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 17
        }
      }, `${commandDef.name} ${usage}`));
    }));
  }, [commandDef]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    columnWidths: [1, 4],
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.securitySolution.console.commandUsage.inputUsage', {
        defaultMessage: 'Usage'
      })),
      description: usageHelp
    }],
    descriptionProps: additionalProps,
    titleProps: additionalProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }), withHelpExample && /*#__PURE__*/_react.default.createElement(CommandInputUsageExample, {
    commandDef: commandDef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 29
    }
  }));
});
CommandInputUsage.displayName = 'CommandInputUsage';
const CommandUsage = exports.CommandUsage = /*#__PURE__*/(0, _react.memo)(({
  commandDef,
  errorMessage
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  const hasArgs = (0, _react.useMemo)(() => {
    var _commandDef$args;
    return Object.keys((_commandDef$args = commandDef.args) !== null && _commandDef$args !== void 0 ? _commandDef$args : []).length > 0;
  }, [commandDef.args]);
  const commandOptions = (0, _react.useMemo)(() => {
    if (!hasArgs || !commandDef.args) {
      return {
        required: [],
        exclusiveOr: [],
        optional: []
      };
    }
    const enteredCommands = Object.entries(commandDef.args).reduce((acc, curr) => {
      const item = {
        title: `--${curr[0]}`,
        description: curr[1].about
      };
      if (curr[1].required) {
        acc.required.push(item);
      } else if (curr[1].exclusiveOr) {
        acc.exclusiveOr.push(item);
      } else {
        acc.optional.push(item);
      }
      return acc;
    }, {
      required: [],
      exclusiveOr: [],
      optional: []
    });
    return enteredCommands;
  }, [commandDef.args, hasArgs]);
  const parametersDescriptionList = (title, parameters) => {
    const description = parameters.map(item => /*#__PURE__*/_react.default.createElement("div", {
      key: item.title,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
      bold: true,
      inline: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 9
      }
    }, item.title), /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
      inline: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 9
      }
    }, ' - ', item.description)));
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 9
      }
    }), commandDef.args && /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true,
      type: "column",
      columnWidths: [1, 4],
      listItems: [{
        title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 201,
            columnNumber: 34
          }
        }, title),
        description
      }],
      descriptionProps: additionalProps,
      titleProps: additionalProps,
      "data-test-subj": getTestId('commandUsage-options'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 11
      }
    }));
  };
  const renderErrorMessage = (0, _react.useCallback)(() => {
    if (!errorMessage) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_unsupported_message_callout.UnsupportedMessageCallout, {
      header: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        textColor: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 218,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.console.validationError.title",
        defaultMessage: "Unsupported action",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 219,
          columnNumber: 13
        }
      })),
      "data-test-subj": getTestId('validationError'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": getTestId('badArgument-message'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 9
      }
    }, errorMessage), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 9
      }
    }));
  }, [errorMessage, getTestId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    color: "transparent",
    "data-test-subj": getTestId('commandUsage'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 5
    }
  }, renderErrorMessage(), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    columnWidths: [1, 4],
    listItems: [{
      title: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 244,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.securitySolution.console.commandUsage.about', {
        defaultMessage: 'About'
      })),
      description: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 250,
          columnNumber: 26
        }
      }, commandDef.about)
    }],
    descriptionProps: additionalProps,
    titleProps: additionalProps,
    "data-test-subj": getTestId('commandUsage-options'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(CommandInputUsage, {
    commandDef: commandDef,
    withHelpExample: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 7
    }
  }), commandOptions.required && commandOptions.required.length > 0 && parametersDescriptionList(_i18n.i18n.translate('xpack.securitySolution.console.commandUsage.requiredLabel', {
    defaultMessage: 'Required parameters'
  }), commandOptions.required), commandOptions.exclusiveOr && commandOptions.exclusiveOr.length > 0 && parametersDescriptionList(_i18n.i18n.translate('xpack.securitySolution.console.commandUsage.exclusiveOr', {
    defaultMessage: 'Include only one parameter'
  }), commandOptions.exclusiveOr), commandOptions.optional && commandOptions.optional.length > 0 && parametersDescriptionList(_i18n.i18n.translate('xpack.securitySolution.console.commandUsage.optional', {
    defaultMessage: 'Optional parameters'
  }), commandOptions.optional), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(CommandInputUsageExample, {
    commandDef: commandDef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 7
    }
  }));
});
CommandUsage.displayName = 'CommandUsage';