"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/usage-collection-plugin/public");
var _pages = require("./pages");
var _use_experimental_features = require("../common/hooks/use_experimental_features");
var _types = require("../app/types");
var _constants = require("../../common/constants");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/kubernetes/routes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const KubernetesRoutesGuard = () => {
  const isKubernetesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('kubernetesEnabled');
  if (!isKubernetesEnabled) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.APP_PATH,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
    viewId: _types.SecurityPageName.kubernetes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_pages.KubernetesContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 9
    }
  })));
};
const routes = exports.routes = [{
  path: _constants.KUBERNETES_PATH,
  component: KubernetesRoutesGuard
}];