"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KubernetesContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/data-plugin/common");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _constants = require("../../common/store/inputs/constants");
var _page_wrapper = require("../../common/components/page_wrapper");
var _kibana = require("../../common/lib/kibana");
var _constants2 = require("../../../common/constants");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _filters_global = require("../../common/components/filters_global");
var _search_bar = require("../../common/components/search_bar");
var _store = require("../../common/store");
var _containers = require("../../sourcerer/containers");
var _use_global_time = require("../../common/containers/use_global_time");
var _use_selector = require("../../common/hooks/use_selector");
var _kuery = require("../../common/lib/kuery");
var _use_invalid_filter_query = require("../../common/hooks/use_invalid_filter_query");
var _sessions_viewer = require("../../common/components/sessions_viewer");
var _constants3 = require("./constants");
var _data_view_spec_to_index_pattern = require("./utils/data_view_spec_to_index_pattern");
var _use_data_view = require("../../data_view_manager/hooks/use_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/kubernetes/pages/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// import { useGlobalFullScreen } from '../../common/containers/use_full_screen';
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const KubernetesContainer = exports.KubernetesContainer = /*#__PURE__*/_react.default.memo(() => {
  const {
    kubernetesSecurity,
    uiSettings
  } = (0, _kibana.useKibana)().services;

  // const { globalFullScreen } = useGlobalFullScreen();
  const {
    sourcererDataView,
    dataViewId
  } = (0, _containers.useSourcererDataView)();
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)();
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const [filterQuery, kqlError] = (0, _react.useMemo)(() => (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    dataViewSpec: sourcererDataView,
    queries: [query],
    filters,
    dataView: experimentalDataView
  }), [filters, sourcererDataView, uiSettings, query, experimentalDataView]);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: 'kubernetesQuery',
    filterQuery,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  const renderSessionsView = (0, _react.useCallback)(sessionsFilterQuery => /*#__PURE__*/_react.default.createElement(_sessions_viewer.SessionsView, {
    tableId: _securitysolutionDataTable.TableId.kubernetesPageSessions,
    endDate: to,
    pageFilters: [],
    startDate: from,
    filterQuery: sessionsFilterQuery,
    columns: _constants3.kubernetesSessionsHeaders,
    defaultColumns: _constants3.kubernetesSessionsHeaders,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }), [from, to]);
  return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, kubernetesSecurity.getKubernetesPage({
    filter:
    /*#__PURE__*/
    // <FiltersGlobal show={showGlobalFilters({ globalFullScreen, graphEventId: undefined })}>
    _react.default.createElement(_filters_global.FiltersGlobal, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
      id: _constants.InputsModelId.global,
      sourcererDataViewSpec: sourcererDataView,
      dataView: experimentalDataView,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 13
      }
    })),
    indexPattern: (0, _data_view_spec_to_index_pattern.dataViewSpecToIndexPattern)(sourcererDataView),
    globalFilter: {
      filterQuery,
      startDate: from,
      endDate: to
    },
    renderSessionsView,
    dataViewId: dataViewId !== null && dataViewId !== void 0 ? dataViewId : undefined
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _constants2.SecurityPageName.kubernetes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }));
});
KubernetesContainer.displayName = 'KubernetesContainer';