"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutHistory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _flyout_history_row = require("./flyout_history_row");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/shared/components/flyout_history.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const flyoutHistoryButtonTooltip = _i18n.i18n.translate('xpack.securitySolution.flyout.right.header.flyoutHistoryButton', {
  defaultMessage: 'Flyout history'
});
/**
 * History of flyouts shown in top navigation
 * Shows the title of previously opened flyout, and count of history of more than 1 flyout was opened
 */
const FlyoutHistory = exports.FlyoutHistory = /*#__PURE__*/(0, _react.memo)(({
  history
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const togglePopover = () => setPopover(!isPopoverOpen);
  const emptyHistoryMessage = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: 0,
      "data-test-subj": _test_ids.NO_DATA_HISTORY_ROW_TEST_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("i", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.history.noData",
      defaultMessage: "No history",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 15
      }
    })))));
  }, []);
  const historyDropdownPanels = (0, _react.useMemo)(() => history.length > 0 ? history.map((item, index) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_flyout_history_row.FlyoutHistoryRow, {
      item: item,
      index: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 17
      }
    }));
  }) : [emptyHistoryMessage], [history, emptyHistoryMessage]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": _test_ids.FLYOUT_HISTORY_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: flyoutHistoryButtonTooltip,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: togglePopover,
      size: "m",
      iconType: 'clockCounter',
      "data-test-subj": _test_ids.FLYOUT_HISTORY_BUTTON_TEST_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 13
      }
    })),
    isOpen: isPopoverOpen,
    closePopover: togglePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: historyDropdownPanels,
    "data-test-subj": _test_ids.FLYOUT_HISTORY_CONTEXT_PANEL_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  })));
});
FlyoutHistory.displayName = 'FlyoutHistory';