"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandablePanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/shared/components/expandable_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Wrapper component that is composed of a header section and a content section.
 * The header can display an icon, a title (that can be a link), and an optional content section on the right.
 * The content section can display a loading spinner, an error message, or any other content.
 * The component can be expanded or collapsed by clicking on the chevron icon on the left of the title.
 */
const ExpandablePanel = ({
  header: {
    title,
    link,
    iconType,
    headerContent
  },
  content: {
    loading,
    error,
    paddingSize: contentPaddingSize
  } = {
    loading: false,
    error: false,
    paddingSize: 'm'
  },
  expand: {
    expandable,
    expandedOnFirstRender
  } = {
    expandable: false,
    expandedOnFirstRender: false
  },
  'data-test-subj': dataTestSubj,
  children
}) => {
  const [toggleStatus, setToggleStatus] = (0, _react.useState)(expandedOnFirstRender);
  const toggleQuery = (0, _react.useCallback)(() => {
    setToggleStatus(!toggleStatus);
  }, [setToggleStatus, toggleStatus]);
  const toggleIcon = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `${dataTestSubj}ToggleIcon`,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.shared.ExpandablePanelButtonIconAriaLabel', {
      defaultMessage: 'Expandable panel toggle'
    }),
    color: "text",
    display: "empty",
    iconType: toggleStatus ? 'arrowDown' : 'arrowRight',
    onClick: toggleQuery,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }), [dataTestSubj, toggleStatus, toggleQuery]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const xsFontSize = (0, _eui.useEuiFontSize)('xs').fontSize;
  const headerLeftSection = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
          min-height: ${euiTheme.size.xl};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    "data-test-subj": `${dataTestSubj}LeftSection`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }, expandable && children && toggleIcon), iconType && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: link !== null && link !== void 0 && link.callback ? 'primary' : 'text',
    type: iconType,
    css: (0, _react2.css)`
                  margin: ${euiTheme.size.s} 0;
                `,
    "data-test-subj": `${dataTestSubj}TitleIcon`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }, link !== null && link !== void 0 && link.callback ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: link === null || link === void 0 ? void 0 : link.tooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    css: (0, _react2.css)`
                    font-size: ${xsFontSize};
                    font-weight: ${euiTheme.font.weight.bold};
                  `,
    "data-test-subj": `${dataTestSubj}TitleLink`,
    onClick: link === null || link === void 0 ? void 0 : link.callback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 17
    }
  }, title)) : /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": `${dataTestSubj}TitleText`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 17
    }
  }, title))))), [euiTheme.size.xl, euiTheme.size.s, euiTheme.font.weight.bold, dataTestSubj, expandable, children, toggleIcon, iconType, link === null || link === void 0 ? void 0 : link.callback, link === null || link === void 0 ? void 0 : link.tooltip, xsFontSize, title]);
  const headerRightSection = (0, _react.useMemo)(() => headerContent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            margin-right: ${euiTheme.size.m};
          `,
    "data-test-subj": `${dataTestSubj}RightSection`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 9
    }
  }, headerContent), [dataTestSubj, euiTheme.size.m, headerContent]);
  const showContent = (0, _react.useMemo)(() => {
    if (!children) {
      return false;
    }
    return !expandable || expandable && toggleStatus;
  }, [children, expandable, toggleStatus]);
  const content = loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": `${dataTestSubj}Loading`,
    contentAriaLabel: _i18n.i18n.translate('xpack.securitySolution.flyout.shared.expandablePanelLoadingAriaLabel', {
      defaultMessage: 'expandable panel'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 5
    }
  }) : error ? null : children;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    grow: true,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued",
    paddingSize: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 9
    }
  }, headerLeftSection, headerRightSection)), showContent && /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: contentPaddingSize,
    "data-test-subj": `${dataTestSubj}Content`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  }, content)));
};
exports.ExpandablePanel = ExpandablePanel;
ExpandablePanel.displayName = 'ExpandablePanel';