"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useManagedUser = void 0;
var _react = require("react");
var _search_strategy = require("../../../../../common/api/search_strategy");
var _use_search_strategy = require("../../../../common/containers/use_search_strategy");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _manage_query = require("../../../../common/components/page/manage_query");
var _constants = require("../constants");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useManagedUser = () => {
  const {
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const {
    loading: loadingManagedUser,
    result: {
      users: managedUserData
    },
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _search_strategy.UsersQueries.managedDetails,
    initialResult: {
      users: {}
    },
    errorMessage: i18n.FAIL_MANAGED_USER
  });
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect,
    refetch,
    setQuery,
    queryId: _constants.MANAGED_USER_QUERY_ID,
    loading: loadingManagedUser
  });
  return (0, _react.useMemo)(() => ({
    data: managedUserData
  }), [managedUserData]);
};
exports.useManagedUser = useManagedUser;