"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenericEntityFlyoutContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _std = require("@kbn/std");
var _analytics = require("@kbn/analytics");
var _types = require("../../../../common/entity_analytics/types");
var _left_panel_header = require("../shared/components/left_panel/left_panel_header");
var _entity_insight = require("../../../cloud_security_posture/components/entity_insight");
var _use_expand_section = require("../../document_details/right/hooks/use_expand_section");
var _constants = require("./constants");
var _fields_table = require("./components/fields_table");
var _expandable_section = require("../../document_details/right/components/expandable_section");
var _flyout_body = require("../../shared/components/flyout_body");
var _expandable_panel = require("../../shared/components/expandable_panel");
var _asset_criticality_selector = require("../../../entity_analytics/components/asset_criticality/asset_criticality_selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/generic_right/content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultPinnedFields = ['entity.name', 'entity.id', 'entity.category', 'entity.type', 'asset.criticality', 'user.name', 'user.email', 'host.name', 'host.os', 'cloud.account.id', 'cloud.region', 'cloud.account.name'];
const GenericEntityFlyoutContent = ({
  source,
  openGenericEntityDetailsPanelByPath,
  insightsField,
  insightsValue,
  onAssetCriticalityChange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const fieldsSectionExpandedState = (0, _use_expand_section.useExpandSection)({
    title: _constants.GENERIC_FLYOUT_STORAGE_KEYS.OVERVIEW_FIELDS_SECTION,
    defaultValue: true
  });
  const {
    pinnedFields
  } = (0, _fields_table.usePinnedFields)(_constants.GENERIC_FLYOUT_STORAGE_KEYS.OVERVIEW_FIELDS_TABLE_PINS);
  const filteredDocument = (0, _react.useMemo)(() => {
    if (!source) return {};
    const flattenedDocument = (0, _std.getFlattenedObject)(source);
    const filtered = Object.entries(flattenedDocument).reduce((acc, [key, value]) => {
      if (pinnedFields !== null && pinnedFields !== void 0 && pinnedFields.includes(key)) {
        acc[key] = value;
      }
      return acc;
    }, {});
    return filtered;
  }, [source, pinnedFields]);
  return /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_asset_criticality_selector.AssetCriticalityAccordion, {
    entity: {
      name: insightsValue,
      type: _types.EntityType.generic
    },
    onChange: () => {
      _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.ASSET_INVENTORY_CRITICALITY_ASSIGNED_MANUAL, _ui_metrics.ASSET_INVENTORY_APP_NAME);
      onAssetCriticalityChange();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_entity_insight.EntityInsight, {
    field: insightsField,
    value: insightsValue,
    isPreviewMode: false,
    openDetailsPanel: openGenericEntityDetailsPanelByPath,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.genericEntityFlyout.flyoutContent.expandableSection.fieldsLabel",
      defaultMessage: "Fields",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 11
      }
    }),
    expanded: fieldsSectionExpandedState,
    localStorageKey: _constants.GENERIC_FLYOUT_STORAGE_KEYS.OVERVIEW_FIELDS_SECTION,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      iconType: 'arrowStart',
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        css: (0, _react2.css)`
                  font-weight: ${euiTheme.font.weight.semiBold};
                `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.genericEntityFlyout.flyoutContent.expandablePanel.highlightedFieldsLabel",
        defaultMessage: "Highlighted Fields",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 17
        }
      })),
      link: {
        callback: () => openGenericEntityDetailsPanelByPath({
          tab: _left_panel_header.EntityDetailsLeftPanelTab.FIELDS_TABLE
        }),
        tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.genericEntityFlyout.flyoutContent.expandablePanel.highlightedFieldsTooltip",
          defaultMessage: "Show all fields",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 142,
            columnNumber: 17
          }
        })
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_fields_table.FieldsTable, {
    document: filteredDocument,
    tableStorageKey: _constants.GENERIC_FLYOUT_STORAGE_KEYS.OVERVIEW_FIELDS_TABLE_PINS,
    euiInMemoryTableProps: {
      search: undefined,
      pagination: undefined
    },
    defaultPinnedFields: defaultPinnedFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }))));
};
exports.GenericEntityFlyoutContent = GenericEntityFlyoutContent;
GenericEntityFlyoutContent.displayName = 'GenericEntityFlyoutContent';