"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUGGESTED_PROMPTS_SECTION_TEST_ID = exports.AI_ASSISTANT_SECTION_TEST_ID = exports.AIAssistantSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _suggested_prompts = require("./suggested_prompts");
var _utils = require("../../document_details/shared/utils");
var _context = require("../context");
var _conversations = require("./conversations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ease/components/ai_assistant_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AI_ASSISTANT_SECTION_TEST_ID = exports.AI_ASSISTANT_SECTION_TEST_ID = 'ease-alert-flyout-ai-assistant-section';
const SUGGESTED_PROMPTS_SECTION_TEST_ID = exports.SUGGESTED_PROMPTS_SECTION_TEST_ID = 'ease-alert-flyout-suggested-prompts-section';
const AI_ASSISTANT = _i18n.i18n.translate('xpack.securitySolution.aiAssistantSection.title', {
  defaultMessage: 'AI Assistant'
});
const SUGGESTED_PROMPTS = _i18n.i18n.translate('xpack.securitySolution.alertSummary.suggestedPromptsSection.title', {
  defaultMessage: 'Suggested prompts'
});
/**
 * Panel to be displayed in EASE alert summary flyout
 */
const AIAssistantSection = exports.AIAssistantSection = /*#__PURE__*/(0, _react.memo)(({
  getPromptContext
}) => {
  const {
    eventId,
    getFieldsData
  } = (0, _context.useEaseDetailsContext)();
  const ruleName = (0, _react.useMemo)(() => (0, _utils.getField)(getFieldsData(_ruleDataUtils.ALERT_RULE_NAME)) || '', [getFieldsData]);
  const timestamp = (0, _react.useMemo)(() => (0, _utils.getField)(getFieldsData(_ruleDataUtils.TIMESTAMP)) || '', [getFieldsData]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": AI_ASSISTANT_SECTION_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  }, AI_ASSISTANT)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_conversations.Conversations, {
    alertId: eventId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": SUGGESTED_PROMPTS_SECTION_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }, SUGGESTED_PROMPTS)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_suggested_prompts.SuggestedPrompts, {
    getPromptContext: getPromptContext,
    ruleName: ruleName,
    timestamp: timestamp,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  })));
});
AIAssistantSection.displayName = 'AIAssistantSection';