"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleDetailsLink = void 0;
var _deeplinksSecurity = require("@kbn/deeplinks-security");
var _rison = require("@kbn/rison");
var _link_to = require("../../../../common/components/link_to");
var _use_url_state = require("../../../../common/hooks/use_url_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook that returns the url to navigate to the rule details page.
 * If the timeline is open from where the hook is being called, set the state to closed.
 */
const useRuleDetailsLink = ({
  ruleId
}) => {
  var _href$split$, _href, _href$split;
  const getSecuritySolutionUrl = (0, _link_to.useGetSecuritySolutionUrl)();
  if (!ruleId) return null;
  const path = (0, _link_to.getRuleDetailsUrl)(ruleId);
  let href = getSecuritySolutionUrl({
    deepLinkId: _deeplinksSecurity.SecurityPageName.rules,
    path
  });
  const sanitisedSeachParams = (_href$split$ = (_href = href) === null || _href === void 0 ? void 0 : (_href$split = _href.split('?')) === null || _href$split === void 0 ? void 0 : _href$split[1]) !== null && _href$split$ !== void 0 ? _href$split$ : '';
  const timelineState = new URLSearchParams(sanitisedSeachParams).get(_use_url_state.URL_PARAM_KEY.timeline);
  if (timelineState) {
    const parsedState = (0, _rison.safeDecode)(timelineState);
    if (parsedState && parsedState.isOpen) {
      const encodedState = (0, _rison.encode)({
        ...parsedState,
        isOpen: false
      });
      href = href.replace(timelineState, encodedState);
    }
  }
  return href;
};
exports.useRuleDetailsLink = useRuleDetailsLink;