"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvestigationTimeEnrichment = exports.QUERY_ID = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _i18n = require("@kbn/i18n");
var _threat_intelligence = require("../services/threat_intelligence");
var _constants = require("../../../../common/store/inputs/constants");
var _constants2 = require("../../../../../common/cti/constants");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _kibana = require("../../../../common/lib/kibana");
var _actions = require("../../../../common/store/actions");
var _constants3 = require("../../../../../common/constants");
var _local_storage = require("../constants/local_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INVESTIGATION_ENRICHMENT_REQUEST_ERROR = _i18n.i18n.translate('xpack.securitySolution.flyout.threatIntelligence.requestError', {
  defaultMessage: `An error occurred while requesting threat intelligence`
});
const QUERY_ID = exports.QUERY_ID = 'investigation_time_enrichment';
const noop = () => {};
const noEnrichments = {
  enrichments: []
};
/**
 * Hook to fetch the enrichment for a set of event fields.
 * Holds the range of the query.
 * Returns the result of the enrichment, the range of the query, the function to set it and the loading state.
 */
const useInvestigationTimeEnrichment = ({
  eventFields
}) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    data,
    storage,
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const defaultThreatIndices = uiSettings.get(_constants3.DEFAULT_THREAT_INDEX_KEY);
  const timeSavedInLocalStorage = storage.get(_local_storage.FLYOUT_STORAGE_KEYS.THREAT_INTELLIGENCE_TIME_RANGE);
  const dispatch = (0, _reactRedux.useDispatch)();
  const [range, setCustomRange] = (0, _react.useState)({
    from: (timeSavedInLocalStorage === null || timeSavedInLocalStorage === void 0 ? void 0 : timeSavedInLocalStorage.start) || _constants2.DEFAULT_EVENT_ENRICHMENT_FROM,
    to: (timeSavedInLocalStorage === null || timeSavedInLocalStorage === void 0 ? void 0 : timeSavedInLocalStorage.end) || _constants2.DEFAULT_EVENT_ENRICHMENT_TO
  });
  const setRange = (0, _react.useCallback)(rge => {
    setCustomRange(rge);
    storage.set(_local_storage.FLYOUT_STORAGE_KEYS.THREAT_INTELLIGENCE_TIME_RANGE, {
      start: rge.from,
      end: rge.to
    });
  }, [storage]);
  const {
    error,
    loading,
    result,
    start
  } = (0, _threat_intelligence.useEventEnrichmentComplete)();
  const deleteQuery = (0, _react.useCallback)(() => {
    dispatch(_actions.inputsActions.deleteOneQuery({
      inputId: _constants.InputsModelId.global,
      id: QUERY_ID
    }));
  }, [dispatch]);
  (0, _react.useEffect)(() => {
    if (!loading && result) {
      dispatch(_actions.inputsActions.setQuery({
        inputId: _constants.InputsModelId.global,
        id: QUERY_ID,
        inspect: {
          dsl: result.inspect.dsl,
          response: [JSON.stringify(result.rawResponse, null, 2)]
        },
        loading,
        refetch: noop
      }));
    }
    return deleteQuery;
  }, [deleteQuery, dispatch, loading, result]);
  (0, _react.useEffect)(() => {
    if (error) {
      addError(error, {
        title: INVESTIGATION_ENRICHMENT_REQUEST_ERROR
      });
    }
  }, [addError, error]);
  const prevEventFields = (0, _usePrevious.default)(eventFields);
  const prevRange = (0, _usePrevious.default)(range);
  (0, _react.useEffect)(() => {
    if (!(0, _lodash.isEmpty)(eventFields) && (!(0, _lodash.isEqual)(eventFields, prevEventFields) || !(0, _lodash.isEqual)(range, prevRange))) {
      start({
        data,
        timerange: {
          ...range,
          interval: ''
        },
        defaultIndex: defaultThreatIndices,
        eventFields,
        filterQuery: ''
      });
    }
  }, [start, data, eventFields, prevEventFields, range, prevRange, defaultThreatIndices]);
  return {
    result: (0, _lodash.isEmpty)(eventFields) ? noEnrichments : result,
    range,
    setRange,
    loading
  };
};
exports.useInvestigationTimeEnrichment = useInvestigationTimeEnrichment;