"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TlsQueryTabBody = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _manage_query = require("../../../../common/components/page/manage_query");
var _tls = require("../../containers/tls");
var _tls_table = require("../../components/tls_table");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/pages/navigation/tls_query_tab_body.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TlsTableManage = (0, _manage_query.manageQuery)(_tls_table.TlsTable);
const TlsQueryTabBodyComponent = ({
  endDate,
  filterQuery,
  flowTarget,
  indexNames,
  ip = '',
  setQuery,
  skip,
  startDate,
  type
}) => {
  const queryId = `${_tls.ID}-${type}`;
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(queryId);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const [loading, {
    id,
    inspect,
    isInspected,
    tls,
    totalCount,
    pageInfo,
    loadPage,
    refetch
  }] = (0, _tls.useNetworkTls)({
    endDate,
    filterQuery,
    flowTarget,
    id: queryId,
    indexNames,
    ip,
    skip: querySkip,
    startDate,
    type
  });
  return /*#__PURE__*/_react.default.createElement(TlsTableManage, {
    data: tls,
    id: id,
    inspect: inspect,
    isInspect: isInspected,
    fakeTotalCount: (0, _fp.getOr)(50, 'fakeTotalCount', pageInfo),
    loading: loading,
    loadPage: loadPage,
    showMorePagesIndicator: (0, _fp.getOr)(false, 'showMorePagesIndicator', pageInfo),
    refetch: refetch,
    setQuery: setQuery,
    setQuerySkip: setQuerySkip,
    totalCount: totalCount,
    type: type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  });
};
TlsQueryTabBodyComponent.displayName = 'TlsQueryTabBodyComponent';
const TlsQueryTabBody = exports.TlsQueryTabBody = /*#__PURE__*/_react.default.memo(TlsQueryTabBodyComponent);