"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SharedLists = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var _securitysolutionExceptionListComponents = require("@kbn/securitysolution-exception-list-components");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _auto_download = require("../../../common/components/auto_download/auto_download");
var _kibana = require("../../../common/lib/kibana");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("../../translations/shared_list"));
var _components = require("../../components");
var _use_all_exception_lists = require("../../hooks/use_all_exception_lists");
var _reference_error_modal = require("../../../common/components/reference_error_modal");
var _api = require("../../../detection_engine/rule_management/api/api");
var _helpers = require("../../../detection_engine/rule_management_ui/components/rules_table/helpers");
var _user_info = require("../../../detections/components/user_info");
var _use_lists_config = require("../../../detections/containers/detection_engine/lists/use_lists_config");
var _missing_privileges = require("../../../common/components/missing_privileges");
var _constants = require("../../../../common/endpoint/service/artifacts/constants");
var _add_exception_flyout = require("../../../detection_engine/rule_exceptions/components/add_exception_flyout");
var _use_endpoint_exceptions_capability = require("../../hooks/use_endpoint_exceptions_capability");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/exceptions/pages/shared_lists/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const exceptionReferenceModalInitialState = {
  contentText: '',
  rulesReferences: [],
  isLoading: false,
  listId: '',
  listNamespaceType: 'single'
};
const SORT_FIELDS = [{
  field: 'created_at',
  label: i18n.SORT_BY_CREATE_AT,
  defaultOrder: 'desc'
}];
const ExceptionsTable = (0, _styled.default)(_eui.EuiFlexGroup)`
  padding: ${({
  theme
}) => theme.euiTheme.size.l} 0;
`;
const SharedLists = exports.SharedLists = /*#__PURE__*/_react.default.memo(() => {
  const [{
    loading: userInfoLoading,
    canUserCRUD,
    canUserREAD
  }] = (0, _user_info.useUserData)();
  const {
    loading: listsConfigLoading
  } = (0, _use_lists_config.useListsConfig)();
  const loading = userInfoLoading || listsConfigLoading;
  const canAccessEndpointExceptions = (0, _use_endpoint_exceptions_capability.useEndpointExceptionsCapability)('showEndpointExceptions');
  const canWriteEndpointExceptions = (0, _use_endpoint_exceptions_capability.useEndpointExceptionsCapability)('crudEndpointExceptions');
  const {
    services: {
      http,
      notifications,
      timelines,
      application: {
        navigateToApp
      }
    }
  } = (0, _kibana.useKibana)();
  const {
    exportExceptionList,
    deleteExceptionList,
    duplicateExceptionList
  } = (0, _securitysolutionListHooks.useApi)(http);
  const [showReferenceErrorModal, setShowReferenceErrorModal] = (0, _react.useState)(false);
  const [referenceModalState, setReferenceModalState] = (0, _react.useState)(exceptionReferenceModalInitialState);
  const [filters, setFilters] = (0, _react.useState)();
  const [viewerStatus, setViewStatus] = (0, _react.useState)(_securitysolutionExceptionListComponents.ViewerStatus.LOADING);
  const exceptionListTypes = (0, _react.useMemo)(() => {
    const lists = [_securitysolutionIoTsListTypes.ExceptionListTypeEnum.DETECTION];
    if (canAccessEndpointExceptions) {
      lists.push(_securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT);
    }
    return lists;
  }, [canAccessEndpointExceptions]);
  const [loadingExceptions, exceptions, pagination, setPagination, refreshExceptions, sort, setSort] = (0, _securitysolutionListHooks.useExceptionLists)({
    errorMessage: i18n.ERROR_EXCEPTION_LISTS,
    filterOptions: {
      ...filters,
      types: exceptionListTypes
    },
    http,
    namespaceTypes: ['single', 'agnostic'],
    notifications,
    hideLists: _constants.ALL_ENDPOINT_ARTIFACT_LIST_IDS.filter(listId => listId !== _securitysolutionListConstants.ENDPOINT_ARTIFACT_LISTS.endpointExceptions.id)
  });
  const [loadingTableInfo, exceptionListsWithRuleRefs, exceptionsListsRef] = (0, _use_all_exception_lists.useAllExceptionLists)({
    exceptionLists: exceptions !== null && exceptions !== void 0 ? exceptions : []
  });
  const [initLoading, setInitLoading] = (0, _react.useState)(true);
  const [lastUpdated, setLastUpdated] = (0, _react.useState)(Date.now());
  const [exportDownload, setExportDownload] = (0, _react.useState)({});
  const [displayImportListFlyout, setDisplayImportListFlyout] = (0, _react.useState)(false);
  const {
    addError,
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();

  // Loading states
  const exceptionsLoaded = !loadingTableInfo && !initLoading;
  const hasNoExceptions = !loadingExceptions && !exceptionListsWithRuleRefs.length;
  const isSearchingExceptions = viewerStatus === _securitysolutionExceptionListComponents.ViewerStatus.SEARCHING;
  const isLoadingExceptions = viewerStatus === _securitysolutionExceptionListComponents.ViewerStatus.LOADING;
  const handleDeleteSuccess = (0, _react.useCallback)(listId => () => {
    notifications.toasts.addSuccess({
      title: i18n.exceptionDeleteSuccessMessage(listId !== null && listId !== void 0 ? listId : referenceModalState.listId)
    });
  }, [notifications.toasts, referenceModalState.listId]);
  const handleDeleteError = (0, _react.useCallback)(err => {
    addError(err, {
      title: i18n.EXCEPTION_DELETE_ERROR
    });
  }, [addError]);
  const handleDelete = (0, _react.useCallback)(({
    id,
    namespaceType
  }) => async () => {
    try {
      if (exceptionsListsRef[id] != null) {
        setReferenceModalState({
          contentText: exceptionsListsRef[id].rules.length > 0 ? i18n.referenceErrorMessage(exceptionsListsRef[id].rules.length) : i18n.defaultDeleteListMessage(exceptionsListsRef[id].name),
          rulesReferences: exceptionsListsRef[id].rules.map(({
            name
          }) => name),
          isLoading: true,
          listId: id,
          listNamespaceType: namespaceType
        });
        setShowReferenceErrorModal(true);
      }
      // route to patch rules with associated exception list
    } catch (error) {
      handleDeleteError(error);
    }
  }, [exceptionsListsRef, handleDeleteError]);
  const handleExportSuccess = (0, _react.useCallback)((listId, name) => blob => {
    addSuccess(i18n.EXCEPTION_LIST_EXPORTED_SUCCESSFULLY(name));
    setExportDownload({
      name: listId,
      blob
    });
  }, [addSuccess]);
  const handleExportError = (0, _react.useCallback)(err => {
    addError(err, {
      title: i18n.EXCEPTION_EXPORT_ERROR
    });
  }, [addError]);
  const handleExport = (0, _react.useCallback)(({
    id,
    listId,
    name,
    namespaceType,
    includeExpiredExceptions
  }) => async () => {
    await exportExceptionList({
      id,
      includeExpiredExceptions,
      listId,
      namespaceType,
      onError: handleExportError,
      onSuccess: handleExportSuccess(listId, name)
    });
  }, [exportExceptionList, handleExportError, handleExportSuccess]);
  const handleRefresh = (0, _react.useCallback)(() => {
    if (refreshExceptions != null) {
      setLastUpdated(Date.now());
      refreshExceptions();
    }
  }, [refreshExceptions]);
  (0, _react.useEffect)(() => {
    if (initLoading && !loading && !loadingExceptions && !loadingTableInfo) {
      setInitLoading(false);
    }
  }, [initLoading, loading, loadingExceptions, loadingTableInfo]);
  const handleSearch = (0, _react.useCallback)(async ({
    query,
    queryText
  }) => {
    setViewStatus(_securitysolutionExceptionListComponents.ViewerStatus.SEARCHING);
    const filterOptions = {
      name: null,
      list_id: null,
      created_by: null,
      type: null,
      tags: null
    };
    const searchTerms = (0, _helpers.getSearchFilters)({
      defaultSearchTerm: 'name',
      filterOptions,
      query,
      searchValue: queryText
    });
    setFilters(searchTerms);
  }, []);
  const handleDuplicationError = (0, _react.useCallback)(err => {
    addError(err, {
      title: i18n.EXCEPTION_DUPLICATE_ERROR
    });
  }, [addError]);
  const handleDuplicateSuccess = (0, _react.useCallback)(name => () => {
    addSuccess(i18n.EXCEPTION_LIST_DUPLICATED_SUCCESSFULLY(name));
    handleRefresh();
  }, [addSuccess, handleRefresh]);
  const handleDuplicate = (0, _react.useCallback)(({
    listId,
    name,
    namespaceType,
    includeExpiredExceptions
  }) => async () => {
    await duplicateExceptionList({
      includeExpiredExceptions,
      listId,
      namespaceType,
      onError: handleDuplicationError,
      onSuccess: handleDuplicateSuccess(name)
    });
  }, [duplicateExceptionList, handleDuplicateSuccess, handleDuplicationError]);
  const handleCloseReferenceErrorModal = (0, _react.useCallback)(() => {
    setShowReferenceErrorModal(false);
    setReferenceModalState({
      contentText: '',
      rulesReferences: [],
      isLoading: false,
      listId: '',
      listNamespaceType: 'single'
    });
  }, []);
  const handleReferenceDelete = (0, _react.useCallback)(async () => {
    const exceptionListId = referenceModalState.listId;
    const exceptionListNamespaceType = referenceModalState.listNamespaceType;
    const relevantRules = exceptionsListsRef[exceptionListId].rules;
    try {
      await Promise.all(relevantRules.map(rule => {
        var _rule$exceptions_list;
        const abortCtrl = new AbortController();
        const exceptionLists = ((_rule$exceptions_list = rule.exceptions_list) !== null && _rule$exceptions_list !== void 0 ? _rule$exceptions_list : []).filter(({
          id
        }) => id !== exceptionListId);
        return (0, _api.patchRule)({
          ruleProperties: {
            rule_id: rule.rule_id,
            exceptions_list: exceptionLists
          },
          signal: abortCtrl.signal
        });
      }));
      await deleteExceptionList({
        id: exceptionListId,
        namespaceType: exceptionListNamespaceType,
        onError: handleDeleteError,
        onSuccess: handleDeleteSuccess()
      });
    } catch (err) {
      handleDeleteError(err);
    } finally {
      setReferenceModalState(exceptionReferenceModalInitialState);
      setShowReferenceErrorModal(false);
      if (refreshExceptions != null) {
        refreshExceptions();
      }
    }
  }, [referenceModalState.listId, referenceModalState.listNamespaceType, exceptionsListsRef, deleteExceptionList, handleDeleteError, handleDeleteSuccess, refreshExceptions]);
  const handleOnDownload = (0, _react.useCallback)(() => {
    setExportDownload({});
  }, []);
  const [activePage, setActivePage] = (0, _react.useState)(0);
  const [rowSize, setRowSize] = (0, _react.useState)(5);
  const [isRowSizePopoverOpen, setIsRowSizePopoverOpen] = (0, _react.useState)(false);
  const onRowSizeButtonClick = () => setIsRowSizePopoverOpen(val => !val);
  const closeRowSizePopover = () => setIsRowSizePopoverOpen(false);
  const rowSizeButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    color: "text",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: onRowSizeButtonClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 5
    }
  }, i18n.allExceptionsRowPerPage(rowSize));
  const getIconType = size => {
    return size === rowSize ? 'check' : 'empty';
  };
  const onPerPageClick = (0, _react.useCallback)(size => {
    closeRowSizePopover();
    setRowSize(size);
    setActivePage(0);
  }, []);
  const rowSizeItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "5 rows",
    icon: getIconType(5),
    onClick: () => onPerPageClick(5),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 413,
      columnNumber: 5
    }
  }, '5 rows'), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "10 rows",
    icon: getIconType(10),
    onClick: () => onPerPageClick(10),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 416,
      columnNumber: 5
    }
  }, '10 rows'), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "25 rows",
    icon: getIconType(25),
    onClick: () => onPerPageClick(25),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 419,
      columnNumber: 5
    }
  }, '25 rows')];
  (0, _react.useEffect)(() => {
    setPagination({
      // off-by-one error
      // we should really update the api to be zero-index based
      // the same way the pagination component in EUI is zero based.
      page: activePage + 1,
      perPage: rowSize,
      total: 0
    });
  }, [activePage, rowSize, setPagination]);
  const goToPage = pageNumber => setActivePage(pageNumber);
  const [isCreatePopoverOpen, setIsCreatePopoverOpen] = (0, _react.useState)(false);
  const [displayAddExceptionItemFlyout, setDisplayAddExceptionItemFlyout] = (0, _react.useState)(false);
  const [displayCreateSharedListFlyout, setDisplayCreateSharedListFlyout] = (0, _react.useState)(false);
  const onCreateButtonClick = () => setIsCreatePopoverOpen(isOpen => !isOpen);
  const onCloseCreatePopover = () => {
    setDisplayAddExceptionItemFlyout(false);
    setIsCreatePopoverOpen(false);
  };
  const onCreateExceptionListOpenClick = () => setDisplayCreateSharedListFlyout(true);
  const isReadOnly = (0, _react.useMemo)(() => {
    var _ref;
    return (_ref = canUserREAD && !canUserCRUD) !== null && _ref !== void 0 ? _ref : true;
  }, [canUserREAD, canUserCRUD]);
  (0, _react.useEffect)(() => {
    if (isSearchingExceptions && hasNoExceptions) {
      setViewStatus(_securitysolutionExceptionListComponents.ViewerStatus.EMPTY_SEARCH);
    } else if (!exceptionsLoaded) {
      setViewStatus(_securitysolutionExceptionListComponents.ViewerStatus.LOADING);
    } else if (isLoadingExceptions && hasNoExceptions) {
      setViewStatus(_securitysolutionExceptionListComponents.ViewerStatus.EMPTY);
    } else if (isLoadingExceptions && exceptionsLoaded) {
      setViewStatus(null);
    }
  }, [isSearchingExceptions, hasNoExceptions, exceptionsLoaded, isLoadingExceptions]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_missing_privileges.MissingPrivilegesCallOut, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 466,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: i18n.ALL_EXCEPTIONS,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      direction: "column",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 470,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 471,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      direction: "row",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 472,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 473,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 474,
        columnNumber: 19
      }
    }, i18n.ALL_EXCEPTIONS_SUBTITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 476,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "popout",
      "aria-label": "go-to-rules",
      color: "primary",
      onClick: () => navigateToApp('security', {
        openInNewTab: true,
        path: '/rules'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 477,
        columnNumber: 19
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 488,
        columnNumber: 13
      }
    }, timelines.getLastUpdated({
      showUpdating: loading,
      updatedAt: lastUpdated
    }))),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      "data-test-subj": "manageExceptionListCreateButton",
      button: !isReadOnly && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconType: 'arrowDown',
        onClick: onCreateButtonClick,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 501,
          columnNumber: 17
        }
      }, i18n.CREATE_BUTTON),
      isOpen: isCreatePopoverOpen,
      closePopover: onCloseCreatePopover,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 497,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: 'createList',
        "data-test-subj": "manageExceptionListCreateExceptionListButton",
        onClick: () => {
          onCloseCreatePopover();
          onCreateExceptionListOpenClick();
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 511,
          columnNumber: 17
        }
      }, i18n.CREATE_SHARED_LIST_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: 'createItem',
        "data-test-subj": "manageExceptionListCreateExceptionButton",
        onClick: () => {
          onCloseCreatePopover();
          setDisplayAddExceptionItemFlyout(true);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 521,
          columnNumber: 17
        }
      }, i18n.CREATE_BUTTON_ITEM_BUTTON)],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 509,
        columnNumber: 13
      }
    })), (!isReadOnly || canWriteEndpointExceptions) && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "importSharedExceptionList",
      iconType: 'importAction',
      onClick: () => setDisplayImportListFlyout(true),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 535,
        columnNumber: 13
      }
    }, i18n.IMPORT_EXCEPTION_LIST_BUTTON)],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 467,
      columnNumber: 7
    }
  }), displayCreateSharedListFlyout && /*#__PURE__*/_react.default.createElement(_components.CreateSharedListFlyout, {
    handleRefresh: handleRefresh,
    http: http,
    addSuccess: addSuccess,
    addError: addError,
    handleCloseFlyout: () => setDisplayCreateSharedListFlyout(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 547,
      columnNumber: 9
    }
  }), displayAddExceptionItemFlyout && /*#__PURE__*/_react.default.createElement(_add_exception_flyout.AddExceptionFlyout, {
    rules: null,
    isEndpointItem: false,
    isBulkAction: false,
    showAlertCloseOptions: true,
    onCancel: () => setDisplayAddExceptionItemFlyout(false),
    onConfirm: didRuleChange => {
      setDisplayAddExceptionItemFlyout(false);
      if (didRuleChange) handleRefresh();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 557,
      columnNumber: 9
    }
  }), displayImportListFlyout && /*#__PURE__*/_react.default.createElement(_components.ImportExceptionListFlyout, {
    handleRefresh: handleRefresh,
    http: http,
    addSuccess: addSuccess,
    addError: addError,
    setDisplayImportListFlyout: setDisplayImportListFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 571,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 580,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "allExceptionListsPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 581,
      columnNumber: 7
    }
  }, !initLoading && /*#__PURE__*/_react.default.createElement(_components.ListsSearchBar, {
    onSearch: handleSearch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 582,
      columnNumber: 26
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 583,
      columnNumber: 9
    }
  }), viewerStatus != null ? /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.EmptyViewerState, {
    isReadOnly: isReadOnly,
    title: i18n.NO_EXCEPTION_LISTS,
    viewerStatus: viewerStatus,
    buttonText: i18n.CREATE_SHARED_LIST_BUTTON,
    body: i18n.NO_LISTS_BODY,
    onEmptyButtonStateClick: onCreateExceptionListOpenClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 585,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.ExceptionsTableUtilityBar, {
    totalExceptionLists: exceptionListsWithRuleRefs.length,
    onRefresh: handleRefresh,
    setSort: setSort,
    sort: sort,
    sortFields: SORT_FIELDS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 595,
      columnNumber: 13
    }
  }), exceptionListsWithRuleRefs.length > 0 && /*#__PURE__*/_react.default.createElement(ExceptionsTable, {
    "data-test-subj": "exceptionsTable",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 603,
      columnNumber: 15
    }
  }, exceptionListsWithRuleRefs.map(excList => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: excList.list_id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 605,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ExceptionsListCard, {
    "data-test-subj": "exceptionsListCard",
    readOnly: excList.list_id === _securitysolutionListConstants.ENDPOINT_ARTIFACT_LISTS.endpointExceptions.id ? !canWriteEndpointExceptions : isReadOnly,
    exceptionsList: excList,
    handleDelete: handleDelete,
    handleExport: handleExport,
    handleDuplicate: handleDuplicate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 606,
      columnNumber: 21
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 624,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 625,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 626,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 627,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: rowSizeButton,
    isOpen: isRowSizePopoverOpen,
    closePopover: closeRowSizePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 628,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: rowSizeItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 633,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      alignItems: 'flex-end'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 638,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 639,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 640,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": 'Custom pagination example',
    pageCount: pagination.total ? Math.ceil(pagination.total / rowSize) : 0,
    activePage: activePage,
    onPageClick: goToPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 641,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_auto_download.AutoDownload, {
    blob: exportDownload.blob,
    name: `${exportDownload.name}.ndjson`,
    onDownload: handleOnDownload,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 652,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_reference_error_modal.ReferenceErrorModal, {
    cancelText: i18n.REFERENCE_MODAL_CANCEL_BUTTON,
    confirmText: i18n.REFERENCE_MODAL_CONFIRM_BUTTON,
    contentText: referenceModalState.contentText,
    onCancel: handleCloseReferenceErrorModal,
    onClose: handleCloseReferenceErrorModal,
    onConfirm: handleReferenceDelete,
    references: referenceModalState.rulesReferences,
    showModal: showReferenceErrorModal,
    titleText: i18n.REFERENCE_MODAL_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 657,
      columnNumber: 9
    }
  })));
});
SharedLists.displayName = 'SharedLists';