"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityAnalyticsRiskScores = exports.ENTITY_RISK_SCORE_TABLE_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _search_strategy = require("../../../../common/search_strategy");
var _manage_query = require("../../../common/components/page/manage_query");
var _constants = require("../../../flyout/entity_details/shared/constants");
var _enable_risk_score = require("../enable_risk_score");
var _columns = require("./columns");
var _last_updated_at = require("../../../common/components/last_updated_at");
var _header_section = require("../../../common/components/header_section");
var _types = require("../../../../common/entity_analytics/types");
var _helpers = require("../../../explore/hosts/store/helpers");
var _use_global_time = require("../../../common/containers/use_global_time");
var _inspect = require("../../../common/components/inspect");
var _query_toggle = require("../../../common/containers/query_toggle");
var _styled_basic_table = require("../styled_basic_table");
var _loader = require("../../../common/components/loader");
var _panel = require("../../../common/components/panel");
var _use_entity = require("./use_entity");
var _header_content = require("./header_content");
var _use_navigate_to_alerts_page_with_filters = require("../../../common/hooks/use_navigate_to_alerts_page_with_filters");
var _translations = require("./translations");
var _kibana = require("../../../common/lib/kibana");
var _use_global_filter_query = require("../../../common/hooks/use_global_filter_query");
var _use_risk_score_kpi = require("../../api/hooks/use_risk_score_kpi");
var _use_risk_score = require("../../api/hooks/use_risk_score");
var _risk_engine_privileges_callout = require("../risk_engine_privileges_callout");
var _use_missing_risk_engine_privileges = require("../../hooks/use_missing_risk_engine_privileges");
var _telemetry = require("../../../common/lib/telemetry");
var _risk_score_no_data_detected = require("../risk_score_no_data_detected");
var _risk_score_header_title = require("../risk_score_header_title");
var _risk_score_donut_chart = require("../risk_score_donut_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_analytics_risk_score/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ENTITY_RISK_SCORE_TABLE_ID = exports.ENTITY_RISK_SCORE_TABLE_ID = 'entity-risk-score-table';
const EntityAnalyticsRiskScoresComponent = ({
  riskEntity
}) => {
  const {
    deleteQuery,
    setQuery,
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const [updatedAt, setUpdatedAt] = (0, _react.useState)(Date.now());
  const entity = (0, _use_entity.useEntityInfo)(riskEntity);
  const openAlertsPageWithFilters = (0, _use_navigate_to_alerts_page_with_filters.useNavigateToAlertsPageWithFilters)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const entityNameField = _types.EntityTypeToIdentifierField[riskEntity];
  const openEntityOnAlertsPage = (0, _react.useCallback)(entityName => {
    telemetry.reportEvent(_telemetry.EntityEventTypes.EntityAlertsClicked, {
      entity: riskEntity
    });
    openAlertsPageWithFilters([{
      title: (0, _translations.getRiskEntityTranslation)(riskEntity),
      selectedOptions: [entityName],
      fieldName: entityNameField
    }]);
  }, [telemetry, riskEntity, openAlertsPageWithFilters, entityNameField]);
  const openEntityOnExpandableFlyout = (0, _react.useCallback)(entityName => {
    const panelKey = _constants.EntityPanelKeyByType[riskEntity];
    const panelParam = _constants.EntityPanelParamByType[riskEntity];
    if (panelKey && panelParam) {
      openRightPanel({
        id: panelKey,
        params: {
          [panelParam]: entityName,
          contextID: ENTITY_RISK_SCORE_TABLE_ID,
          scopeId: ENTITY_RISK_SCORE_TABLE_ID
        }
      });
    }
  }, [openRightPanel, riskEntity]);
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(entity.tableQueryId);
  const columns = (0, _react.useMemo)(() => (0, _columns.getRiskScoreColumns)(riskEntity, openEntityOnAlertsPage, openEntityOnExpandableFlyout), [riskEntity, openEntityOnAlertsPage, openEntityOnExpandableFlyout]);
  const [selectedSeverity, setSelectedSeverity] = (0, _react.useState)([]);
  const onSelectSeverityFilter = (0, _react.useCallback)(newSelection => {
    setSelectedSeverity(newSelection);
  }, []);
  const severityFilter = (0, _react.useMemo)(() => {
    const [filter] = (0, _helpers.generateSeverityFilter)(selectedSeverity, riskEntity);
    return filter ? filter : undefined;
  }, [riskEntity, selectedSeverity]);
  const {
    filterQuery
  } = (0, _use_global_filter_query.useGlobalFilterQuery)({
    extraFilter: severityFilter
  });
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const {
    severityCount,
    loading: isKpiLoading,
    refetch: refetchKpi,
    inspect: inspectKpi
  } = (0, _use_risk_score_kpi.useRiskScoreKpi)({
    filterQuery,
    skip: !toggleStatus,
    timerange,
    riskEntity
  });
  (0, _manage_query.useQueryInspector)({
    queryId: entity.kpiQueryId,
    loading: isKpiLoading,
    refetch: refetchKpi,
    setQuery,
    deleteQuery,
    inspect: inspectKpi
  });
  const {
    data,
    loading: isTableLoading,
    inspect,
    refetch,
    isAuthorized,
    hasEngineBeenInstalled
  } = (0, _use_risk_score.useRiskScore)({
    filterQuery,
    skip: !toggleStatus,
    pagination: {
      cursorStart: 0,
      querySize: 5
    },
    timerange,
    riskEntity,
    includeAlertsCount: true
  });
  (0, _manage_query.useQueryInspector)({
    queryId: entity.tableQueryId,
    loading: isTableLoading,
    refetch,
    setQuery,
    deleteQuery,
    inspect
  });
  (0, _react.useEffect)(() => {
    setUpdatedAt(Date.now());
  }, [isTableLoading, isKpiLoading]); // Update the time when data loads

  const privileges = (0, _use_missing_risk_engine_privileges.useMissingRiskEnginePrivileges)({
    readonly: true
  });
  if (!isAuthorized) {
    return null;
  }
  const isDisabled = !hasEngineBeenInstalled && !isTableLoading;
  if (!privileges.isLoading && !privileges.hasAllRequiredPrivileges) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_risk_engine_privileges_callout.RiskEnginePrivilegesCallOut, {
      privileges: privileges,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 9
      }
    }));
  }
  if (isDisabled) {
    return /*#__PURE__*/_react.default.createElement(_enable_risk_score.EnableRiskScore, {
      isDisabled: isDisabled,
      entityType: riskEntity,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 12
      }
    });
  }
  if (hasEngineBeenInstalled && selectedSeverity.length === 0 && data && data.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_risk_score_no_data_detected.RiskScoresNoDataDetected, {
      entityType: riskEntity,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_panel.Panel, {
    hasBorder: true,
    "data-test-subj": `entity_analytics_${riskEntity}s`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
      riskScoreEntity: riskEntity,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 18
      }
    }),
    titleSize: "s",
    subtitle: /*#__PURE__*/_react.default.createElement(_last_updated_at.LastUpdatedAt, {
      isUpdating: isTableLoading || isKpiLoading,
      updatedAt: updatedAt,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 13
      }
    }),
    id: entity.tableQueryId,
    toggleStatus: toggleStatus,
    toggleQuery: setToggleStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_header_content.RiskScoreHeaderContent, {
    entityLinkProps: entity.linkProps,
    onSelectSeverityFilter: onSelectSeverityFilter,
    riskEntity: riskEntity,
    selectedSeverity: selectedSeverity,
    toggleStatus: toggleStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 11
    }
  })), toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "entity_analytics_content",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_risk_score_donut_chart.RiskScoreDonutChart, {
    severityCount: severityCount !== null && severityCount !== void 0 ? severityCount : _search_strategy.EMPTY_SEVERITY_COUNT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_styled_basic_table.StyledBasicTable, {
    responsiveBreakpoint: false,
    items: data !== null && data !== void 0 ? data : [],
    columns: columns,
    loading: isTableLoading,
    id: entity.tableQueryId,
    rowProps: {
      className: 'EntityAnalyticsTableHoverActions'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 15
    }
  }))), (isTableLoading || isKpiLoading) && /*#__PURE__*/_react.default.createElement(_loader.Loader, {
    "data-test-subj": "loadingPanelRiskScore",
    overlay: true,
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 11
    }
  })));
};
const EntityAnalyticsRiskScores = exports.EntityAnalyticsRiskScores = /*#__PURE__*/_react.default.memo(EntityAnalyticsRiskScoresComponent);
EntityAnalyticsRiskScores.displayName = 'EntityAnalyticsRiskScores';